/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class Dictionary
extends MIDlet
implements CommandListener {
    TextBox mainMenu;
    static Command QUIT_CMD = new Command("\u0412\u044b\u0445\u043e\u0434", 7, 2);
    static Command BACK_CMD = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 2);
    static Command TRANSLATE_CMD = new Command("\u041f\u0435\u0440\u0435\u0432\u043e\u0434", 4, 1);
    static final int ENG = 0;
    static final int RUS = 1;
    static final String[] LANGUAGE = new String[]{"eng", "rus"};
    static final int MAX_LENGTH = 32;
    static final int MAX_FILE_SIZE = 8192;
    static final int SELECTION_LIMIT = 32;
    Volume[][] volumes;
    int[] nVolumes;
    byte[] buf = new byte[8192];

    int findVolume(int n, String string) {
        int n2 = 0;
        int n3 = this.nVolumes[n];
        while (n2 < n3) {
            int n4 = n2 + n3 >> 1;
            if (string.compareTo(this.volumes[n][n4].last) > 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n3;
    }

    int findVolume(int n, int n2) {
        int n3 = 0;
        int n4 = this.nVolumes[n];
        while (n3 < n4) {
            int n5 = n3 + n4 >> 1;
            if (n2 > this.volumes[n][n5].index) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5;
        }
        System.out.println("Found word with index " + n2 + " in volume " + n4 + ", total volumes " + this.nVolumes[n]);
        return n4;
    }

    public Dictionary() throws IOException {
        this.volumes = new Volume[2][];
        this.nVolumes = new int[2];
        this.buildIndex(0, "/eng.idx");
        this.buildIndex(1, "/rus.idx");
        this.mainMenu = new TextBox("\u041f\u0440\u0435\u0444\u0438\u043a\u0441 \u0441\u043b\u043e\u0432\u0430", "", 32, 0);
        this.mainMenu.addCommand(QUIT_CMD);
        this.mainMenu.addCommand(TRANSLATE_CMD);
        this.mainMenu.setCommandListener((CommandListener)this);
    }

    protected void destroyApp(boolean bl) {
        this.mainMenu = null;
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainMenu);
    }

    static int unpackInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static String unpackString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + i];
            cArray[i] = (char)(n3 < 0 ? (n3 == -88 ? 1025 : (n3 == -72 ? 1105 : 0x400 | (n3 & 0x7F) - 48)) : n3);
        }
        return new String(cArray);
    }

    static String unpackString(byte[] byArray) {
        return Dictionary.unpackString(byArray, 0, byArray.length);
    }

    private void buildIndex(int n, String string) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(string));
        Vector<Volume> vector = new Vector<Volume>();
        try {
            while (true) {
                byte by = dataInputStream.readByte();
                byte[] byArray = new byte[by];
                dataInputStream.read(byArray);
                Volume volume = new Volume();
                volume.last = Dictionary.unpackString(byArray);
                volume.index = dataInputStream.readInt();
                vector.addElement(volume);
            }
        }
        catch (EOFException eOFException) {
            dataInputStream.close();
            int n2 = vector.size();
            this.volumes[n] = new Volume[n2];
            for (int i = 0; i < n2; ++i) {
                this.volumes[n][i] = (Volume)vector.elementAt(i);
            }
            this.nVolumes[n] = n2;
            return;
        }
    }

    public String getTranslation(Translation translation) {
        try {
            int n = 1 - translation.lang;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < translation.index.length; ++i) {
                int n2 = translation.index[i];
                int n3 = this.findVolume(n, n2);
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(LANGUAGE[n] + '.' + (n3 + 1));
                int n4 = inputStream.read(this.buf);
                inputStream.close();
                String string = null;
                if (n3 > 0) {
                    n2 -= this.volumes[n][n3 - 1].index + 1;
                    string = this.volumes[n][n3 - 1].last;
                }
                int n5 = 0;
                do {
                    int n6 = this.buf[n5++] & 0xFF;
                    int n7 = this.buf[n5] & 0xFF;
                    String string2 = Dictionary.unpackString(this.buf, n5, n6);
                    n5 += n6 + 4;
                    if (n6 > 0 && n7 <= 32) {
                        string2 = string.substring(0, n7) + string2.substring(1);
                    }
                    string = string2;
                } while (--n2 >= 0);
                if (translation.index.length == 1) {
                    return string;
                }
                stringBuffer.append(Integer.toString(i + 1));
                stringBuffer.append(". ");
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Vector getSelection(String string) {
        Vector vector;
        int n = 0;
        int n2 = string.length();
        while (--n2 >= 0) {
            if (string.charAt(n2) <= 'z') continue;
            n = 1;
            break;
        }
        if ((vector = this.getSelection(string, n)).size() == 0) {
            vector = this.getSelection(string, 1 - n);
        }
        return vector;
    }

    private Vector getSelection(String string, int n) {
        Vector<Translation> vector = new Vector<Translation>();
        try {
            Translation translation = null;
            for (int i = this.findVolume(n, string); i < this.nVolumes[n]; ++i) {
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(LANGUAGE[n] + '.' + (i + 1));
                int n2 = inputStream.read(this.buf);
                inputStream.close();
                String string2 = i > 0 ? this.volumes[n][i - 1].last : null;
                int n3 = 0;
                boolean bl = false;
                while (n3 < n2) {
                    int n4 = this.buf[n3++] & 0xFF;
                    int n5 = this.buf[n3] & 0xFF;
                    String string3 = Dictionary.unpackString(this.buf, n3, n4);
                    int n6 = Dictionary.unpackInt(this.buf, n3 += n4);
                    n3 += 4;
                    if (n4 > 0 && n5 <= 32) {
                        string3 = string2.substring(0, n5) + string3.substring(1);
                    }
                    if (string3.compareTo(string) >= 0) {
                        if (string3.startsWith(string)) {
                            bl = true;
                        } else if (bl) {
                            return vector;
                        }
                        if (string3.equals(string2)) {
                            int[] nArray = new int[translation.index.length + 1];
                            System.arraycopy(translation.index, 0, nArray, 0, translation.index.length);
                            nArray[nArray.length - 1] = n6;
                            translation.index = nArray;
                        } else {
                            if (vector.size() == 32) {
                                return vector;
                            }
                            translation = new Translation(string3, new int[]{n6}, n);
                            vector.addElement(translation);
                        }
                    }
                    string2 = string3;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return vector;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == QUIT_CMD) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            String string = this.mainMenu.getString().toLowerCase();
            if (string.length() != 0) {
                this.mainMenu.setTitle("\u041c\u0438\u043d\u0443\u0442\u043e\u0447\u043a\u0443");
                this.mainMenu.setString("\u0418\u0434\u0451\u0442 \u043f\u043e\u0438\u0441\u043a...");
                Vector vector = this.getSelection(string);
                switch (vector.size()) {
                    case 0: {
                        Alert alert = new Alert(string, "\u041d\u0435\u0442 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432", null, AlertType.ERROR);
                        alert.setTimeout(-2);
                        Display.getDisplay((MIDlet)this).setCurrent(alert, (Displayable)this.mainMenu);
                        break;
                    }
                    case 1: {
                        Translation translation = (Translation)vector.firstElement();
                        if (translation.word.equals(string)) {
                            new TranslationBox(this, (Displayable)this.mainMenu, (Translation)vector.firstElement());
                            break;
                        }
                    }
                    default: {
                        new PrefixList(this, (Displayable)this.mainMenu, vector);
                    }
                }
                this.mainMenu.setTitle("\u041f\u0440\u0435\u0444\u0438\u043a\u0441 \u0441\u043b\u043e\u0432\u0430");
                this.mainMenu.setString(string);
            }
        }
    }

    class Volume {
        String last;
        int index;

        Volume() {
        }
    }
}

