/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class MobileMap
extends MIDlet {
    static final Command QUIT_CMD = new Command("\u0412\u044b\u0445\u043e\u0434", 2, 2);
    static final Command BACK_CMD = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 2);
    static final Command SEARCH_CMD = new Command("\u041f\u043e\u0438\u0441\u043a", 1, 1);
    static final Command OBJECTS_CMD = new Command("\u041e\u0431\u044a\u0435\u043a\u0442\u044b", 1, 1);
    static final Command METRO_CMD = new Command("\u0421\u0442\u0430\u043d\u0446\u0438\u0438 \u043c\u0435\u0442\u0440\u043e", 1, 1);
    static final Command SELECT_CMD = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 1, 1);
    static final Command OPTIONS_CMD = new Command("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 1, 1);
    static final Command SAVE_CMD = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 1, 1);
    static final Command RESET_CMD = new Command("\u041e\u0431\u0449\u0438\u0439 \u043f\u043b\u0430\u043d", 1, 2);
    static final Command HELP_CMD = new Command("\u041f\u043e\u043c\u043e\u0449\u044c", 1, 3);
    static final Command ABOUT_CMD = new Command("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 1, 4);
    static final int OBJECT_MAX_COUNT = 40;
    static final int METRO_MAX_COUNT = 70;
    static final String MAP_FILE = "/city";
    static final String MAP_FILE_STR = "/str.map";
    static final int CELL_BITS = 3;
    static final int N_CELLS = 8;
    int nLevels;
    int[] nLevelStreets;
    int nMetroStations;
    int[] MetroStations;
    int nObjects;
    int[] Objects;
    Street[] streets;
    Segment[][][] cells;
    byte Option_ShowFont1;
    byte Option_ShowFont2;

    String toLowerCaseRUS(String prefix) {
        char[] str = prefix.toCharArray();
        for (int i = 0; i < str.length; ++i) {
            if (str[i] < '\u0410' || str[i] > '\u042f') continue;
            str[i] = (char)(str[i] + 32);
        }
        return String.valueOf(str);
    }

    int findStreet(String prefix) {
        int l = 0;
        int r = this.streets.length;
        while (l < r) {
            int m = Math.abs((l + r) / 2);
            if (prefix.compareTo(this.streets[m].name) > 0) {
                l = m + 1;
                continue;
            }
            r = m;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int SaveOptions() {
        RecordStore rs = null;
        try {
            byte[] abyte0 = new byte[1];
            rs = RecordStore.openRecordStore((String)"Settings", (boolean)true);
            try {
                int num_par = 1;
                abyte0[0] = this.Option_ShowFont1;
                if (rs.getNumRecords() >= 1) {
                    rs.setRecord(num_par, abyte0, 0, abyte0.length);
                } else {
                    rs.addRecord(abyte0, 0, abyte0.length);
                }
                ++num_par;
                abyte0[0] = this.Option_ShowFont2;
                if (rs.getNumRecords() >= 2) {
                    rs.setRecord(num_par, abyte0, 0, abyte0.length);
                } else {
                    rs.addRecord(abyte0, 0, abyte0.length);
                }
            }
            finally {
                rs.closeRecordStore();
                rs = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    int LoadOptions() {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)"Settings", (boolean)true);
            if (rs.getNumRecords() > 0) {
                int num_par = 1;
                byte[] abyte0 = rs.getRecord(num_par);
                if (abyte0 != null) {
                    this.Option_ShowFont1 = abyte0[0];
                }
                if (rs.getNumRecords() >= ++num_par && (abyte0 = rs.getRecord(num_par)) != null) {
                    this.Option_ShowFont2 = abyte0[0];
                }
            } else {
                this.Option_ShowFont1 = 1;
                this.Option_ShowFont2 = (byte)2;
                this.SaveOptions();
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    public MobileMap() throws Exception {
        int j;
        int i;
        this.LoadOptions();
        this.Objects = new int[40];
        this.nObjects = 0;
        this.MetroStations = new int[70];
        this.nMetroStations = 0;
        DataInputStream in = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(MAP_FILE_STR));
        int nStreets = in.readShort();
        this.streets = new Street[nStreets];
        for (i = 0; i < nStreets; ++i) {
            Street street = new Street();
            street.segments = new Segment[in.readShort()];
            int len = in.readByte();
            byte[] name = new byte[len];
            for (j = 0; j < len; ++j) {
                name[j] = in.readByte();
            }
            byte TpLine = in.readByte();
            street.name = this.toLowerCaseRUS(Locale.decodeString(name));
            street.TypeLine = TpLine;
            this.streets[i] = street;
            if (TpLine == 7) {
                if (this.nObjects >= 40) continue;
                ++this.nObjects;
                this.Objects[this.nObjects - 1] = i;
                continue;
            }
            if (TpLine != 8 || this.nMetroStations >= 70) continue;
            ++this.nMetroStations;
            this.MetroStations[this.nMetroStations - 1] = i;
        }
        this.cells = new Segment[8][8][];
        for (i = 0; i < 8; ++i) {
            for (int j2 = 0; j2 < 8; ++j2) {
                this.cells[i][j2] = new Segment[in.readShort()];
            }
        }
        this.nLevels = in.readByte();
        this.nLevelStreets = new int[this.nLevels];
        int[][] cellPos = new int[8][8];
        short[] segmentPos = new short[nStreets];
        for (int i2 = 0; i2 < this.nLevels; ++i2) {
            in.close();
            in = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(MAP_FILE + i2 + ".map"));
            short nSegments = in.readShort();
            this.nLevelStreets[i2] = nSegments;
            for (j = 0; j < nSegments; ++j) {
                Segment s = new Segment();
                short s2 = s.streetIndex = in.readShort();
                short s3 = segmentPos[s2];
                segmentPos[s2] = (short)(s3 + 1);
                this.streets[s.streetIndex].segments[s3] = s;
                s.level = (byte)i2;
                int nPoints = in.readByte() & 0xFF;
                s.x = new short[nPoints];
                s.y = new short[nPoints];
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (int k = 0; k < nPoints; ++k) {
                    int x = in.readShort() & 0xFFFF;
                    int y = in.readShort() & 0xFFFF;
                    if (x < minX) {
                        minX = x;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (y < minY) {
                        minY = y;
                    }
                    if (y > maxY) {
                        maxY = y;
                    }
                    s.x[k] = (short)x;
                    s.y[k] = (short)y;
                }
                maxX >>>= 13;
                minY >>>= 13;
                maxY >>>= 13;
                for (int cx = minX >>>= 13; cx <= maxX; ++cx) {
                    for (int cy = minY; cy <= maxY; ++cy) {
                        int[] nArray = cellPos[cx];
                        int n = cy;
                        int n2 = nArray[n];
                        nArray[n] = n2 + 1;
                        this.cells[cx][cy][n2] = s;
                    }
                }
            }
        }
    }

    protected void destroyApp(boolean unconditional) {
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        new MapCanvas(this);
    }

    public void quit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }
}

