/*
 * Decompiled with CFR 0.152.
 */
package Mbook;

import Mbook.BookReader;
import Mbook.BookmarkList;
import Mbook.IFont;
import Mbook.ImageFont;
import Mbook.Locale;
import Mbook.Menu;
import Mbook.SettingsForm;
import Mbook.SystemFontWrapper;
import com.nokia.mid.ui.FullCanvas;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ReaderCanvas
extends FullCanvas {
    BookReader reader;
    int screenWidth;
    int screenHeight;
    int fontHeight;
    int screenLines;
    int nLines;
    int[] linePos;
    char[] linePrevChar;
    char prevPageChar;
    IFont font;
    Font clockFont;
    Image imgBuf;
    int spaceWidth;
    int hyphenWidth;
    String searchPattern;
    int searchPos;
    String defaultBookmark;
    boolean initialized;
    Timer repeatTimer;
    RepeatTask repeatTask;
    static final int WHITE = 0xFFFFFF;
    static final int BLACK = 0;
    static final int SLIDER_COLOR = 0x8080FF;
    static final int SLIDER_POS_COLOR = 0xFF0000;
    static final int CLOCK_COLOR = 0x88FFFF;
    static final int MIN_SLIDER_LENGTH = 3;
    static final int MAX_BOOKMARK_LENGTH = 16;
    static final int REPEAT_DELAY = 1000;
    static final int REPEAT_PERIOD = 100;
    static final int INDENTATION = 3;

    ReaderCanvas(BookReader reader) {
        this.reader = reader;
        this.prevPageChar = (char)10;
        this.searchPos = -1;
        this.initialized = false;
        this.repeatTimer = new Timer();
        this.clockFont = Font.getFont((int)32, (int)1, (int)16);
    }

    void resetFont() {
        switch (this.reader.font) {
            case 0: {
                this.font = new SystemFontWrapper(Font.getFont((int)64, (int)0, (int)8));
                break;
            }
            case 1: {
                this.font = new SystemFontWrapper(Font.getFont((int)64, (int)0, (int)0));
                break;
            }
            case 2: {
                this.font = new SystemFontWrapper(Font.getFont((int)64, (int)0, (int)16));
                break;
            }
            default: {
                this.font = new ImageFont("fonts/" + SettingsForm.fontName[this.reader.font]);
            }
        }
        this.fontHeight = this.font.getHeight() - this.reader.overlap;
        this.spaceWidth = this.font.charWidth(' ');
        this.hyphenWidth = this.font.charWidth('-');
        this.screenHeight = this.getHeight();
        if ((this.reader.flags & 1) != 0) {
            --this.screenHeight;
        }
        this.screenWidth = this.getWidth();
        if ((this.reader.flags & 2) != 0) {
            --this.screenWidth;
        }
        this.screenLines = this.screenHeight / this.fontHeight;
        this.linePos = new int[this.screenLines + 1];
        this.linePrevChar = new char[this.screenLines + 1];
        this.initialized = true;
    }

    static void insertSpaces(StringBuffer buf, int nSpaces) {
        if (nSpaces > 0) {
            int i;
            int n = buf.length();
            for (i = 0; i < n && buf.charAt(i) == ' '; ++i) {
            }
            int nSeparators = 0;
            while (++i < n) {
                if (buf.charAt(i) != ' ') continue;
                ++nSeparators;
            }
            if (nSeparators != 0) {
                int ns1 = nSpaces / nSeparators;
                int ns2 = nSpaces % nSeparators;
                do {
                    if (buf.charAt(--i) != ' ') continue;
                    for (int j = 0; j < ns1; ++j) {
                        buf.insert(i, ' ');
                    }
                    if (ns2 != 0) {
                        buf.insert(i, ' ');
                        --ns2;
                    }
                    --nSeparators;
                } while (nSeparators != 0);
            }
        }
    }

    private static boolean isSeparator(char ch) {
        return ch == ' ' || ch == '!' || ch == '.' || ch == ',' || ch == ';' || ch == '?' || ch == '-' || ch == '+' || ch == '=' || ch == ')' || ch == '}' || ch == ']' || ch == '\\' || ch == '/' || ch == ':' || ch == '>';
    }

    int splitWord(StringBuffer buf, int n, int width) {
        char c1 = buf.charAt(n - 1);
        char c2 = buf.charAt(n - 2);
        if (ReaderCanvas.isSeparator(c2)) {
            if (c2 == ' ') {
                buf.delete(n - 2, buf.length());
                width -= this.spaceWidth + this.font.charWidth(c1);
            } else {
                buf.delete(n - 1, buf.length());
                width -= this.font.charWidth(c1);
            }
            ReaderCanvas.insertSpaces(buf, (this.screenWidth - width) / this.spaceWidth);
            return 1;
        }
        int i = Locale.split(buf, n);
        if (i < 0) {
            for (i = n - 2; i > 0 && !ReaderCanvas.isSeparator(buf.charAt(i - 1)); --i) {
            }
        }
        if (i <= 0) {
            i = n - 2;
        }
        int rest = n - i;
        boolean insertHyphen = true;
        if (i >= 1 && ReaderCanvas.isSeparator(buf.charAt(i - 1))) {
            --i;
            insertHyphen = false;
        }
        for (int j = i; j < n; ++j) {
            width -= this.font.charWidth(buf.charAt(j));
        }
        buf.delete(i, buf.length());
        if (insertHyphen) {
            buf.insert(i, '-');
            width += this.hyphenWidth;
        }
        ReaderCanvas.insertSpaces(buf, (this.screenWidth - width) / this.spaceWidth);
        return rest;
    }

    protected synchronized void paint(Graphics g) {
        if (!this.initialized) {
            this.resetFont();
        }
        g.setColor((this.reader.flags & 8) != 0 ? 0 : 0xFFFFFF);
        g.fillRect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        if (this.reader.font <= 2 && (this.reader.flags & 4) != 0) {
            g.setColor(0x88FFFF);
            g.setFont(this.clockFont);
            g.drawString(this.reader.getTime(), this.screenWidth, 0, 24);
        }
        g.setColor((this.reader.flags & 8) != 0 ? 0xFFFFFF : 0);
        int pos = this.reader.currPagePos;
        int prevChar = this.prevPageChar;
        boolean eof = false;
        this.nLines = 0;
        this.defaultBookmark = null;
        for (int i = 0; !eof && i < this.screenLines; ++i) {
            String bm;
            this.linePos[i] = pos;
            this.linePrevChar[i] = prevChar;
            ++this.nLines;
            int width = 0;
            StringBuffer buf = new StringBuffer();
            do {
                int ch;
                if ((ch = this.reader.getChar(pos++)) == 32) {
                    if (prevChar == 10) {
                        if (buf.length() >= 3) continue;
                        buf.append((char)ch);
                        width += this.spaceWidth;
                        continue;
                    }
                    if (prevChar == 32 || buf.length() == 0) {
                        continue;
                    }
                } else {
                    if (ch == 0) {
                        eof = true;
                        break;
                    }
                    if (ch == 10) {
                        ch = this.reader.getChar(pos);
                        if (ch == 32 || ch == 10) {
                            prevChar = 10;
                            break;
                        }
                        ch = 32;
                    }
                }
                buf.append((char)ch);
                width += this.font.charWidth((char)ch);
                prevChar = ch;
            } while (width <= this.screenWidth);
            if (this.defaultBookmark == null && this.linePrevChar[i] == '\n' && (bm = buf.toString().trim()).length() > 0) {
                if (bm.length() > 16) {
                    int j;
                    for (j = 16; j > 0 && bm.charAt(j) != ' '; --j) {
                    }
                    bm = bm.substring(0, j);
                }
                this.defaultBookmark = bm;
            }
            if (width > this.screenWidth) {
                if (prevChar == 32 || prevChar == 10) {
                    buf.deleteCharAt(buf.length() - 1);
                    ReaderCanvas.insertSpaces(buf, (this.screenWidth - (width -= this.spaceWidth)) / this.spaceWidth);
                } else {
                    int n = buf.length();
                    if (!eof) {
                        char ch;
                        int p = pos;
                        while ((ch = this.reader.getChar(p++)) > ' ') {
                            buf.append(ch);
                        }
                    }
                    pos -= this.splitWord(buf, n, width);
                }
            }
            this.font.drawString(g, 0, i * this.fontHeight, buf.toString());
        }
        this.linePos[this.nLines] = pos;
        this.linePrevChar[this.nLines] = prevChar;
        if (this.reader.fileLength != 0) {
            int sliderPos;
            int sliderLength;
            if ((this.reader.flags & 1) != 0) {
                sliderLength = (pos - this.reader.currPagePos) * this.screenWidth / this.reader.fileLength;
                if (sliderLength < 3) {
                    sliderLength = 3;
                }
                sliderPos = this.reader.currPagePos * this.screenWidth / this.reader.fileLength;
                g.setColor(0x8080FF);
                g.drawLine(0, this.screenHeight, this.screenWidth, this.screenHeight);
                g.setColor(0xFF0000);
                g.drawLine(sliderPos, this.screenHeight, sliderPos + sliderLength, this.screenHeight);
            }
            if ((this.reader.flags & 2) != 0) {
                sliderLength = (pos - this.reader.currPagePos) * this.screenHeight / this.reader.fileLength;
                if (sliderLength < 3) {
                    sliderLength = 3;
                }
                sliderPos = this.reader.currPagePos * this.screenHeight / this.reader.fileLength;
                g.setColor(0x8080FF);
                g.drawLine(this.screenWidth, 0, this.screenWidth, this.screenHeight);
                g.setColor(0xFF0000);
                g.drawLine(this.screenWidth, sliderPos, this.screenWidth, sliderPos + sliderLength);
                g.setColor(0xFF0000);
                g.drawLine(this.screenWidth - 1, sliderPos, this.screenWidth - 1, sliderPos + sliderLength);
            }
        }
    }

    void moveBackward(int shift) {
        int pos = this.reader.currPagePos;
        int width = 0;
        this.prevPageChar = (char)10;
        while (--pos >= 0 && shift > 0) {
            char ch = this.reader.getChar(pos);
            if (ch == '\n') {
                width = 0;
                --shift;
                this.prevPageChar = (char)10;
                continue;
            }
            if ((width += this.font.charWidth(ch)) <= this.screenWidth) continue;
            width = 0;
            --shift;
            this.prevPageChar = (char)32;
        }
        this.reader.currPagePos = pos + 1;
    }

    void moveForward(int shift) {
        if (this.nLines == this.screenLines) {
            if (shift > this.screenLines) {
                shift = this.screenLines;
            }
            this.reader.currPagePos = this.linePos[shift];
            this.prevPageChar = this.linePrevChar[shift];
        }
    }

    public void setPosition(int pos) {
        if (pos == Integer.MAX_VALUE) {
            this.reader.currPagePos = this.reader.fileLength;
            this.moveBackward(this.screenLines / 2);
        } else {
            this.reader.currPagePos = pos;
        }
    }

    public void keyPressed(int keyCode) {
        if (this.repeatTask != null) {
            this.repeatTask.cancel();
        }
        this.repeatTask = new RepeatTask(keyCode);
        this.repeatTimer.schedule((TimerTask)this.repeatTask, 1000L, 100L);
    }

    public void keyReleased(int keyCode) {
        this.keyAction(keyCode);
        if (this.repeatTask != null) {
            this.repeatTask.cancel();
            this.repeatTask = null;
        }
    }

    public synchronized void keyAction(int keyCode) {
        block0 : switch (keyCode) {
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.moveForward(keyCode - 48);
                break;
            }
            case 48: {
                new BookmarkList(this, (Displayable)this);
                return;
            }
            case 42: {
                if (this.searchPos >= 0) {
                    this.searchPos = this.reader.search(this.searchPos + this.searchPattern.length(), this.searchPattern);
                    if (this.searchPos >= 0) {
                        this.reader.currPagePos = this.searchPos;
                        break;
                    }
                    this.reader.error("\u041f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", (Displayable)this);
                    return;
                }
            }
            case 35: {
                new Menu(this);
                return;
            }
            default: {
                switch (this.getGameAction(keyCode)) {
                    case 2: {
                        this.moveBackward(1);
                        break block0;
                    }
                    case 5: {
                        this.moveForward(1);
                        break block0;
                    }
                    case 1: {
                        this.moveBackward(this.screenLines);
                        break block0;
                    }
                    case 6: {
                        this.moveForward(this.screenLines);
                        break block0;
                    }
                }
                return;
            }
        }
        this.repaint();
        this.reader.saveCurrentPosition();
    }

    class RepeatTask
    extends TimerTask {
        int keyCode;

        RepeatTask(int keyCode) {
            this.keyCode = keyCode;
        }

        public void run() {
            ReaderCanvas.this.keyAction(this.keyCode);
        }
    }
}

