/*
 * Decompiled with CFR 0.152.
 */
package Mbook;

import Mbook.Bookmark;
import Mbook.Converter;
import Mbook.Locale;
import Mbook.ReaderCanvas;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;

public class BookReader
extends MIDlet {
    static final Command BACK_CMD = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 1);
    static final Command QUIT_CMD = new Command("\u0412\u044b\u0445\u043e\u0434", 3, 2);
    static final Command BOOKMARKS_CMD = new Command("\u0417\u0430\u043a\u043b\u0430\u0434\u043a\u0438", 1, 1);
    static final Command GOTO_CMD = new Command("\u041f\u0435\u0440\u0435\u0445\u043e\u0434", 1, 1);
    static final Command ADD_CMD = new Command("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", 1, 2);
    static final Command RENAME_CMD = new Command("\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c", 1, 1);
    static final Command REMOVE_CMD = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", 1, 3);
    static final Command SEARCH_CMD = new Command("\u041f\u043e\u0438\u0441\u043a", 1, 2);
    static final Command SETTINGS_CMD = new Command("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 1, 3);
    static final Command SAVE_CMD = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 1, 1);
    static final Command CLOCK_CMD = new Command("\u0412\u0440\u0435\u043c\u044f", 1, 4);
    static final Command HELP_CMD = new Command("\u041f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430", 1, 5);
    static final String BOOK = "book.txt";
    static final String STORE_NAME = "BOOK_READER";
    static final int DEFAULT_OVERLAP = 1;
    static final int BUF_SIZE = 8192;
    InputStream in;
    static final int POSITION_OFFS = 0;
    static final int FLAGS_OFFS = 4;
    static final int FONT_OFFS = 5;
    static final int OVERLAP_OFFS = 6;
    static final int RECORD_SIZE = 8;
    Vector bookmarks;
    RecordStore store;
    int bufPos;
    int currPagePos;
    int fileLength;
    int overlap;
    int font;
    int flags;
    byte[] buf;
    Calendar calendar;

    private int insertBookmark(Bookmark bm) {
        int n;
        int pos = bm.pos;
        int l = 0;
        int r = n = this.bookmarks.size();
        while (l < r) {
            int m = l + r >> 1;
            if (pos > ((Bookmark)this.bookmarks.elementAt((int)m)).pos) {
                l = m + 1;
                continue;
            }
            r = m;
        }
        this.bookmarks.insertElementAt(bm, r);
        return r;
    }

    public int search(int fromPos, String pattern) {
        char ch;
        char[] p = pattern.toLowerCase().toCharArray();
        int n = p.length;
        char[] q = new char[n];
        char prev = '\u0000';
        int i = 0;
        block0: while ((ch = this.getChar(fromPos++)) != '\u0000') {
            if (ch == ' ' && prev == ' ') continue;
            prev = ch;
            if (i == n) {
                i = 0;
            }
            q[i++] = Character.toLowerCase(ch);
            int j = 0;
            int k = i;
            while (k < n) {
                if (p[j] != q[k]) continue block0;
                ++k;
                ++j;
            }
            k = 0;
            while (j < n) {
                if (p[j] != q[k]) continue block0;
                ++k;
                ++j;
            }
            return fromPos - n;
        }
        return -1;
    }

    public int addBookmark(Bookmark bm) {
        byte[] record = bm.pack();
        try {
            bm.id = this.store.addRecord(record, 0, record.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.insertBookmark(bm);
    }

    public void updateBookmark(Bookmark bm) {
        byte[] record = bm.pack();
        try {
            this.store.setRecord(bm.id, record, 0, record.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeBookmark(int i) {
        try {
            this.store.deleteRecord(((Bookmark)this.bookmarks.elementAt((int)i)).id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bookmarks.removeElementAt(i);
    }

    public void saveCurrentPosition() {
        byte[] record = new byte[8];
        record[4] = (byte)this.flags;
        record[6] = (byte)this.overlap;
        record[5] = (byte)this.font;
        Converter.packInt(record, 0, this.currPagePos);
        try {
            this.store.setRecord(1, record, 0, record.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void openStore() {
        block12: {
            try {
                this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                int last = this.store.getNextRecordID();
                if (last > 1) {
                    byte[] record = this.store.getRecord(1);
                    this.flags = record[4];
                    this.font = record[5];
                    this.overlap = record[6];
                    this.currPagePos = Converter.unpackInt(record, 0);
                    for (int i = 2; i < last; ++i) {
                        try {
                            this.insertBookmark(new Bookmark(i, this.store.getRecord(i)));
                            continue;
                        }
                        catch (InvalidRecordIDException x) {
                            // empty catch block
                        }
                    }
                    break block12;
                }
                byte[] record = new byte[8];
                this.flags = 5;
                this.overlap = 1;
                this.font = 0;
                record[4] = (byte)this.flags;
                record[6] = (byte)this.overlap;
                record[5] = (byte)this.font;
                this.store.addRecord(record, 0, record.length);
                this.addBookmark(new Bookmark(0, "\u0412 \u043d\u0430\u0447\u0430\u043b\u043e"));
                try {
                    DataInputStream content = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/content"));
                    if (content != null) {
                        while (true) {
                            int pos = content.readInt();
                            int len = content.readByte() & 0xFF;
                            byte[] nameBytes = new byte[len];
                            content.readFully(nameBytes);
                            char[] nameChars = new char[len];
                            for (int i = 0; i < len; ++i) {
                                nameChars[i] = Locale.getChar(nameBytes[i]);
                            }
                            this.addBookmark(new Bookmark(pos, new String(nameChars)));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.fileLength != 0) {
                    this.addBookmark(new Bookmark(Integer.MAX_VALUE, "\u0412 \u043a\u043e\u043d\u0435\u0446"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStore() {
        if (this.store != null) {
            try {
                this.store.closeRecordStore();
                this.store = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BookReader() {
        String bookSize = this.getAppProperty("book.size");
        System.out.println("Book size " + bookSize);
        if (bookSize != null) {
            this.fileLength = Integer.parseInt(bookSize);
        } else {
            try {
                DataInputStream cfg = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream("config"));
                this.fileLength = cfg.readInt();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.calendar = Calendar.getInstance();
        this.buf = new byte[8192];
        this.rewind();
        this.fillBuffer();
        this.bookmarks = new Vector();
        this.openStore();
    }

    String getTime() {
        this.calendar.setTime(new Date());
        int hour = this.calendar.get(10);
        String h = "0" + (this.calendar.get(9) == 1 && hour < 12 ? 12 + hour : hour);
        String m = "0" + this.calendar.get(12);
        return h.substring(h.length() - 2) + ':' + m.substring(m.length() - 2);
    }

    private void fillBuffer() {
        int offs;
        try {
            int rc;
            for (offs = 0; offs < this.buf.length && (rc = this.in.read(this.buf, offs, this.buf.length - offs)) > 0; offs += rc) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (offs >= 0 && offs < 8192) {
            this.buf[offs] = 0;
        }
    }

    private boolean moveTo(int pos) {
        int offs;
        int n = offs = pos <= 4096 ? 0 : pos - 4096;
        if (pos < this.bufPos) {
            this.rewind();
        } else {
            this.bufPos += 8192;
            offs -= this.bufPos;
        }
        if (offs > 0) {
            long skipped = 0L;
            try {
                skipped = this.in.skip(offs);
            }
            catch (IOException x) {
                // empty catch block
            }
            if (skipped < (long)offs) {
                return false;
            }
            this.bufPos += offs;
        }
        this.fillBuffer();
        return true;
    }

    private void rewind() {
        this.bufPos = 0;
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.in = ((Object)((Object)this)).getClass().getResourceAsStream(BOOK);
    }

    public char getChar(int pos) {
        if (pos < this.bufPos ? !this.moveTo(pos) : pos >= this.bufPos + 8192 && (pos == this.bufPos + 8192 ? !this.moveForward() : !this.moveTo(pos))) {
            return '\u0000';
        }
        return Locale.getChar(this.buf[pos - this.bufPos]);
    }

    private boolean moveForward() {
        int offs;
        System.arraycopy(this.buf, 4096, this.buf, 0, 4096);
        this.bufPos += 4096;
        try {
            int rc;
            for (offs = 0; offs < 4096; offs += rc) {
                rc = this.in.read(this.buf, 4096 + offs, 4096 - offs);
                if (rc > 0) continue;
                if (offs == 0) {
                    return false;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (offs < 4096) {
            this.buf[4096 + offs] = 0;
        }
        return true;
    }

    public void error(String message, Displayable parent) {
        Alert a = new Alert("\u041e\u0448\u0438\u0431\u043a\u0430", message, null, AlertType.ERROR);
        a.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(a, parent);
    }

    protected void destroyApp(boolean unconditional) {
        this.saveCurrentPosition();
        this.closeStore();
    }

    protected void pauseApp() {
        this.saveCurrentPosition();
    }

    protected void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)new ReaderCanvas(this));
    }

    public void quit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }
}

