/*
 * Decompiled with CFR 0.152.
 */
package Mbook;

import Mbook.IFont;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageFont
implements IFont {
    private int[] _props;
    private byte[] _width;
    private String _fontName;
    private boolean isLoaded;
    private Image _buf;
    private int _count;
    private int _height;

    public ImageFont(String fontName) {
        this._fontName = fontName;
        this.loadFont();
    }

    private int getWord(InputStream stream) throws IOException {
        int lo = stream.read();
        int hi = stream.read();
        if (lo < 0 || hi < 0) {
            return -1;
        }
        return hi * 256 + lo;
    }

    public void loadFont() {
        if (this.isLoaded) {
            this.clear();
        }
        try {
            InputStream in = this.getClass().getResourceAsStream(this._fontName + ".props");
            System.out.println("Open properties");
            this._count = this.getWord(in);
            this._props = new int[this._count];
            this._width = new byte[this._count];
            for (int i = 0; i < this._count; ++i) {
                this._props[i] = this.getWord(in);
                if (i <= 0) continue;
                this._width[i - 1] = (byte)(this._props[i] - this._props[i - 1]);
            }
            this._buf = Image.createImage((String)(this._fontName + ".png"));
            this._height = this._buf.getHeight();
            this._width[this._count - 1] = (byte)(this._buf.getWidth() - this._props[this._count - 1]);
            this.isLoaded = true;
        }
        catch (Exception e) {
            System.out.println("createImage throws exception " + e);
            e.printStackTrace();
            this.clear();
            return;
        }
    }

    public void drawString(Graphics g, int x, int y, String s) {
        if (!this.isLoaded) {
            g.drawString("Font isn't loaded!", 0, 0, 0);
            System.out.println("Can't draw string: Font isn't loaded");
            return;
        }
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        int offs = x;
        for (int i = 0; i < s.length(); ++i) {
            int ch = s.charAt(i) - '\u0001';
            ch = ch == 1024 ? 167 : (ch == 1104 ? 183 : ch);
            int n = ch = ch > 1024 ? ch - 848 : ch;
            if (ch < 0 || ch >= this._count) continue;
            byte width = this._width[ch];
            if (ch > 31) {
                int imgx = this._props[ch];
                g.setClip(offs, y, (int)width, this._height);
                g.drawImage(this._buf, offs - imgx, y, 20);
            }
            offs += width;
        }
        g.setClip(clipx, clipy, clipw, cliph);
    }

    public int charWidth(char ch) {
        if (!this.isLoaded) {
            System.out.println("Can't get char width: Font isn't loaded");
            return 0;
        }
        ch = (char)((ch = (char)(ch == '\u0401' ? 168 : (ch == '\u0451' ? 184 : (int)ch))) > '\u0400' ? (ch == '\u0451' ? 184 : (ch == '\u0401' ? 168 : ch - 849)) : ch - '\u0001');
        if (ch < '\u0000' || ch >= this._count) {
            return 0;
        }
        return this._width[ch];
    }

    public int getHeight() {
        return this._height;
    }

    private void clear() {
        if (!this.isLoaded) {
            return;
        }
        this._fontName = "";
        this._buf = null;
        this._props = null;
        this._width = null;
        this._height = 0;
    }
}

