/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class SdwUtil {
    static int[][] edgeList;
    static int edgeMin;
    static int edgeMax;
    static int r1;
    static int r2;
    static int r3;
    static int r4;
    public static final int[] sinTab;
    public static final int[] cosTab;

    SdwUtil() {
    }

    public static void SetupEdgeList(int n, int n2) {
        edgeList = new int[2][n2];
        edgeMin = n;
        edgeMax = n + n2 - 1;
    }

    public static int SinCalc(int n, int n2) {
        return n * sinTab[n2 & 0x3FF] >> 16;
    }

    public static int CosCalc(int n, int n2) {
        return n * cosTab[n2 & 0x3FF] >> 16;
    }

    public static void Seed(int n) {
        r1 = n;
    }

    public static int Rand() {
        int n = r1 ^ r1 << 11;
        r1 = r2;
        r2 = r3;
        r3 = r4;
        r4 = r4 ^ r4 >> 19 ^ (n ^ n >> 8);
        return r4;
    }

    public static void DrawTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n2 < edgeMin && n4 < edgeMin && n6 < edgeMin) {
            return;
        }
        if (n2 > edgeMax && n4 > edgeMax && n6 > edgeMax) {
            return;
        }
        int n7 = Math.abs(n4 - n2);
        int n8 = Math.abs(n6 - n4);
        int n9 = Math.abs(n2 - n6);
        if (n7 > n8 && n7 > n9) {
            SdwUtil.SetupEdge(n, n2, n3, n4, 0);
            SdwUtil.SetupEdge(n3, n4, n5, n6, 1);
            SdwUtil.SetupEdge(n5, n6, n, n2, 1);
        } else if (n8 >= n7 && n8 >= n9) {
            SdwUtil.SetupEdge(n, n2, n3, n4, 1);
            SdwUtil.SetupEdge(n3, n4, n5, n6, 0);
            SdwUtil.SetupEdge(n5, n6, n, n2, 1);
        } else {
            SdwUtil.SetupEdge(n, n2, n3, n4, 1);
            SdwUtil.SetupEdge(n3, n4, n5, n6, 1);
            SdwUtil.SetupEdge(n5, n6, n, n2, 0);
        }
        int n10 = n2;
        int n11 = n2;
        if (n4 < n10) {
            n10 = n4;
        }
        if (n6 < n10) {
            n10 = n6;
        }
        if (n4 > n11) {
            n11 = n4;
        }
        if (n6 > n11) {
            n11 = n6;
        }
        if (n10 < edgeMin) {
            n10 = edgeMin;
        }
        if (n11 > edgeMax) {
            n11 = edgeMax;
        }
        for (int i = n10 - edgeMin; i < n11 - edgeMin; ++i) {
            graphics.drawLine(edgeList[0][i], i + edgeMin, edgeList[1][i], edgeMin + i);
        }
    }

    public static void SetupEdge(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n4 < n2) {
            n6 = n3;
            n3 = n;
            n = n6;
            n6 = n4;
            n4 = n2;
            n2 = n6;
        }
        n6 = n4 - n2 == 0 ? 0 : (n3 - n << 16) / (n4 - n2);
        int n7 = n << 16;
        for (int i = n2; i < n4; ++i) {
            if (i >= edgeMin && i <= edgeMax) {
                SdwUtil.edgeList[n5][i - SdwUtil.edgeMin] = n7 >> 16;
            }
            n7 += n6;
        }
    }

    static {
        edgeMin = 0;
        edgeMax = 0;
        r2 = 42502087;
        r3 = 579807591;
        r4 = 73326509;
        sinTab = new int[]{0, 402, 804, 1206, 1608, 2010, 2412, 2814, 3215, 3617, 4018, 4420, 4821, 5222, 5622, 6023, 6423, 6823, 7223, 7623, 8022, 8421, 8819, 9218, 9616, 10013, 10410, 10807, 11204, 11600, 11995, 12390, 12785, 13179, 13573, 13966, 14359, 14751, 15142, 15533, 15923, 16313, 16702, 17091, 17479, 17866, 18253, 18638, 19024, 19408, 19792, 20175, 20557, 20938, 21319, 21699, 22078, 22456, 22833, 23210, 23586, 23960, 24334, 24707, 25079, 25450, 25820, 26189, 26557, 26925, 27291, 27656, 28020, 28383, 28745, 29105, 29465, 29824, 30181, 30538, 30893, 31247, 31600, 31952, 32302, 32651, 32999, 33346, 33692, 34036, 34379, 34721, 35061, 35400, 35738, 36074, 36409, 36743, 37075, 37406, 37736, 38064, 38390, 38716, 39039, 39362, 39682, 40002, 40319, 40636, 40950, 41263, 41575, 41885, 42194, 42501, 42806, 43110, 43412, 43712, 44011, 44308, 44603, 44897, 45189, 45480, 45768, 46055, 46340, 46624, 46906, 47186, 47464, 47740, 48015, 48288, 48558, 48828, 49095, 49360, 49624, 49886, 50146, 50403, 50660, 50914, 51166, 51416, 51665, 51911, 52155, 52398, 52639, 52877, 53114, 53348, 53581, 53811, 54040, 54266, 54491, 54713, 54933, 55152, 55368, 55582, 55794, 56004, 56212, 56417, 56621, 56822, 57022, 57219, 57414, 57606, 57797, 57986, 58172, 58356, 58538, 58718, 58895, 59070, 59243, 59414, 59583, 59749, 59913, 60075, 60235, 60392, 60547, 60700, 60850, 60998, 61144, 61288, 61429, 61568, 61705, 61839, 61971, 62100, 62228, 62353, 62475, 62596, 62714, 62829, 62942, 63053, 63162, 63268, 63371, 63473, 63571, 63668, 63762, 63854, 63943, 64030, 64115, 64197, 64276, 64353, 64428, 64501, 64571, 64638, 64703, 64766, 64826, 64884, 64939, 64992, 65043, 65091, 65136, 65179, 65220, 65258, 65294, 65327, 65358, 65386, 65412, 65436, 65457, 65475, 65491, 65505, 65516, 65524, 65531, 65534, 65536, 65534, 65531, 65524, 65516, 65505, 65491, 65475, 65457, 65436, 65412, 65386, 65358, 65327, 65294, 65258, 65220, 65179, 65136, 65091, 65043, 64992, 64939, 64884, 64826, 64766, 64703, 64638, 64571, 64501, 64428, 64353, 64276, 64197, 64115, 64030, 63943, 63854, 63762, 63668, 63571, 63473, 63371, 63268, 63162, 63053, 62942, 62829, 62714, 62596, 62475, 62353, 62228, 62100, 61971, 61839, 61705, 61568, 61429, 61288, 61144, 60998, 60850, 60700, 60547, 60392, 60235, 60075, 59913, 59749, 59583, 59414, 59243, 59070, 58895, 58718, 58538, 58356, 58172, 57986, 57797, 57606, 57414, 57219, 57022, 56822, 56621, 56417, 56212, 56004, 55794, 55582, 55368, 55152, 54933, 54713, 54491, 54266, 54040, 53811, 53581, 53348, 53114, 52877, 52639, 52398, 52155, 51911, 51665, 51416, 51166, 50914, 50660, 50403, 50146, 49886, 49624, 49360, 49095, 48828, 48558, 48288, 48015, 47740, 47464, 47186, 46906, 46624, 46340, 46055, 45768, 45480, 45189, 44897, 44603, 44308, 44011, 43712, 43412, 43110, 42806, 42501, 42194, 41885, 41575, 41263, 40950, 40636, 40319, 40002, 39682, 39362, 39039, 38716, 38390, 38064, 37736, 37406, 37075, 36743, 36409, 36074, 35738, 35400, 35061, 34721, 34379, 34036, 33692, 33346, 32999, 32651, 32302, 31952, 31600, 31247, 30893, 30538, 30181, 29824, 29465, 29105, 28745, 28383, 28020, 27656, 27291, 26925, 26557, 26189, 25820, 25450, 25079, 24707, 24334, 23960, 23586, 23210, 22833, 22456, 22078, 21699, 21319, 20938, 20557, 20175, 19792, 19408, 19024, 18638, 18253, 17866, 17479, 17091, 16702, 16313, 15923, 15533, 15142, 14751, 14359, 13966, 13573, 13179, 12785, 12390, 11995, 11600, 11204, 10807, 10410, 10013, 9616, 9218, 8819, 8421, 8022, 7623, 7223, 6823, 6423, 6023, 5622, 5222, 4821, 4420, 4018, 3617, 3215, 2814, 2412, 2010, 1608, 1206, 804, 402, 0, -403, -805, -1207, -1609, -2011, -2413, -2815, -3216, -3618, -4019, -4421, -4822, -5223, -5623, -6024, -6424, -6824, -7224, -7624, -8023, -8422, -8820, -9219, -9617, -10014, -10411, -10808, -11205, -11601, -11996, -12391, -12786, -13180, -13574, -13967, -14360, -14752, -15143, -15534, -15924, -16314, -16703, -17092, -17480, -17867, -18254, -18639, -19025, -19409, -19793, -20176, -20558, -20939, -21320, -21700, -22079, -22457, -22834, -23211, -23587, -23961, -24335, -24708, -25080, -25451, -25821, -26190, -26558, -26926, -27292, -27657, -28021, -28384, -28746, -29106, -29466, -29825, -30182, -30539, -30894, -31248, -31601, -31953, -32303, -32652, -33000, -33347, -33693, -34037, -34380, -34722, -35062, -35401, -35739, -36075, -36410, -36744, -37076, -37407, -37737, -38065, -38391, -38717, -39040, -39363, -39683, -40003, -40320, -40637, -40951, -41264, -41576, -41886, -42195, -42502, -42807, -43111, -43413, -43713, -44012, -44309, -44604, -44898, -45190, -45481, -45769, -46056, -46341, -46625, -46907, -47187, -47465, -47741, -48016, -48289, -48559, -48829, -49096, -49361, -49625, -49887, -50147, -50404, -50661, -50915, -51167, -51417, -51666, -51912, -52156, -52399, -52640, -52878, -53115, -53349, -53582, -53812, -54041, -54267, -54492, -54714, -54934, -55153, -55369, -55583, -55795, -56005, -56213, -56418, -56622, -56823, -57023, -57220, -57415, -57607, -57798, -57987, -58173, -58357, -58539, -58719, -58896, -59071, -59244, -59415, -59584, -59750, -59914, -60076, -60236, -60393, -60548, -60701, -60851, -60999, -61145, -61289, -61430, -61569, -61706, -61840, -61972, -62101, -62229, -62354, -62476, -62597, -62715, -62830, -62943, -63054, -63163, -63269, -63372, -63474, -63572, -63669, -63763, -63855, -63944, -64031, -64116, -64198, -64277, -64354, -64429, -64502, -64572, -64639, -64704, -64767, -64827, -64885, -64940, -64993, -65044, -65092, -65137, -65180, -65221, -65259, -65295, -65328, -65359, -65387, -65413, -65437, -65458, -65476, -65492, -65506, -65517, -65525, -65532, -65535, -65536, -65535, -65532, -65525, -65517, -65506, -65492, -65476, -65458, -65437, -65413, -65387, -65359, -65328, -65295, -65259, -65221, -65180, -65137, -65092, -65044, -64993, -64940, -64885, -64827, -64767, -64704, -64639, -64572, -64502, -64429, -64354, -64277, -64198, -64116, -64031, -63944, -63855, -63763, -63669, -63572, -63474, -63372, -63269, -63163, -63054, -62943, -62830, -62715, -62597, -62476, -62354, -62229, -62101, -61972, -61840, -61706, -61569, -61430, -61289, -61145, -60999, -60851, -60701, -60548, -60393, -60236, -60076, -59914, -59750, -59584, -59415, -59244, -59071, -58896, -58719, -58539, -58357, -58173, -57987, -57798, -57607, -57415, -57220, -57023, -56823, -56622, -56418, -56213, -56005, -55795, -55583, -55369, -55153, -54934, -54714, -54492, -54267, -54041, -53812, -53582, -53349, -53115, -52878, -52640, -52399, -52156, -51912, -51666, -51417, -51167, -50915, -50661, -50404, -50147, -49887, -49625, -49361, -49096, -48829, -48559, -48289, -48016, -47741, -47465, -47187, -46907, -46625, -46341, -46056, -45769, -45481, -45190, -44898, -44604, -44309, -44012, -43713, -43413, -43111, -42807, -42502, -42195, -41886, -41576, -41264, -40951, -40637, -40320, -40003, -39683, -39363, -39040, -38717, -38391, -38065, -37737, -37407, -37076, -36744, -36410, -36075, -35739, -35401, -35062, -34722, -34380, -34037, -33693, -33347, -33000, -32652, -32303, -31953, -31601, -31248, -30894, -30539, -30182, -29825, -29466, -29106, -28746, -28384, -28021, -27657, -27292, -26926, -26558, -26190, -25821, -25451, -25080, -24708, -24335, -23961, -23587, -23211, -22834, -22457, -22079, -21700, -21320, -20939, -20558, -20176, -19793, -19409, -19025, -18639, -18254, -17867, -17480, -17092, -16703, -16314, -15924, -15534, -15143, -14752, -14360, -13967, -13574, -13180, -12786, -12391, -11996, -11601, -11205, -10808, -10411, -10014, -9617, -9219, -8820, -8422, -8023, -7624, -7224, -6824, -6424, -6024, -5623, -5223, -4822, -4421, -4019, -3618, -3216, -2815, -2413, -2011, -1609, -1207, -805, -403};
        cosTab = new int[]{65536, 65534, 65531, 65524, 65516, 65505, 65491, 65475, 65457, 65436, 65412, 65386, 65358, 65327, 65294, 65258, 65220, 65179, 65136, 65091, 65043, 64992, 64939, 64884, 64826, 64766, 64703, 64638, 64571, 64501, 64428, 64353, 64276, 64197, 64115, 64030, 63943, 63854, 63762, 63668, 63571, 63473, 63371, 63268, 63162, 63053, 62942, 62829, 62714, 62596, 62475, 62353, 62228, 62100, 61971, 61839, 61705, 61568, 61429, 61288, 61144, 60998, 60850, 60700, 60547, 60392, 60235, 60075, 59913, 59749, 59583, 59414, 59243, 59070, 58895, 58718, 58538, 58356, 58172, 57986, 57797, 57606, 57414, 57219, 57022, 56822, 56621, 56417, 56212, 56004, 55794, 55582, 55368, 55152, 54933, 54713, 54491, 54266, 54040, 53811, 53581, 53348, 53114, 52877, 52639, 52398, 52155, 51911, 51665, 51416, 51166, 50914, 50660, 50403, 50146, 49886, 49624, 49360, 49095, 48828, 48558, 48288, 48015, 47740, 47464, 47186, 46906, 46624, 46340, 46055, 45768, 45480, 45189, 44897, 44603, 44308, 44011, 43712, 43412, 43110, 42806, 42501, 42194, 41885, 41575, 41263, 40950, 40636, 40319, 40002, 39682, 39362, 39039, 38716, 38390, 38064, 37736, 37406, 37075, 36743, 36409, 36074, 35738, 35400, 35061, 34721, 34379, 34036, 33692, 33346, 32999, 32651, 32302, 31952, 31600, 31247, 30893, 30538, 30181, 29824, 29465, 29105, 28745, 28383, 28020, 27656, 27291, 26925, 26557, 26189, 25820, 25450, 25079, 24707, 24334, 23960, 23586, 23210, 22833, 22456, 22078, 21699, 21319, 20938, 20557, 20175, 19792, 19408, 19024, 18638, 18253, 17866, 17479, 17091, 16702, 16313, 15923, 15533, 15142, 14751, 14359, 13966, 13573, 13179, 12785, 12390, 11995, 11600, 11204, 10807, 10410, 10013, 9616, 9218, 8819, 8421, 8022, 7623, 7223, 6823, 6423, 6023, 5622, 5222, 4821, 4420, 4018, 3617, 3215, 2814, 2412, 2010, 1608, 1206, 804, 402, 0, -403, -805, -1207, -1609, -2011, -2413, -2815, -3216, -3618, -4019, -4421, -4822, -5223, -5623, -6024, -6424, -6824, -7224, -7624, -8023, -8422, -8820, -9219, -9617, -10014, -10411, -10808, -11205, -11601, -11996, -12391, -12786, -13180, -13574, -13967, -14360, -14752, -15143, -15534, -15924, -16314, -16703, -17092, -17480, -17867, -18254, -18639, -19025, -19409, -19793, -20176, -20558, -20939, -21320, -21700, -22079, -22457, -22834, -23211, -23587, -23961, -24335, -24708, -25080, -25451, -25821, -26190, -26558, -26926, -27292, -27657, -28021, -28384, -28746, -29106, -29466, -29825, -30182, -30539, -30894, -31248, -31601, -31953, -32303, -32652, -33000, -33347, -33693, -34037, -34380, -34722, -35062, -35401, -35739, -36075, -36410, -36744, -37076, -37407, -37737, -38065, -38391, -38717, -39040, -39363, -39683, -40003, -40320, -40637, -40951, -41264, -41576, -41886, -42195, -42502, -42807, -43111, -43413, -43713, -44012, -44309, -44604, -44898, -45190, -45481, -45769, -46056, -46341, -46625, -46907, -47187, -47465, -47741, -48016, -48289, -48559, -48829, -49096, -49361, -49625, -49887, -50147, -50404, -50661, -50915, -51167, -51417, -51666, -51912, -52156, -52399, -52640, -52878, -53115, -53349, -53582, -53812, -54041, -54267, -54492, -54714, -54934, -55153, -55369, -55583, -55795, -56005, -56213, -56418, -56622, -56823, -57023, -57220, -57415, -57607, -57798, -57987, -58173, -58357, -58539, -58719, -58896, -59071, -59244, -59415, -59584, -59750, -59914, -60076, -60236, -60393, -60548, -60701, -60851, -60999, -61145, -61289, -61430, -61569, -61706, -61840, -61972, -62101, -62229, -62354, -62476, -62597, -62715, -62830, -62943, -63054, -63163, -63269, -63372, -63474, -63572, -63669, -63763, -63855, -63944, -64031, -64116, -64198, -64277, -64354, -64429, -64502, -64572, -64639, -64704, -64767, -64827, -64885, -64940, -64993, -65044, -65092, -65137, -65180, -65221, -65259, -65295, -65328, -65359, -65387, -65413, -65437, -65458, -65476, -65492, -65506, -65517, -65525, -65532, -65535, -65536, -65535, -65532, -65525, -65517, -65506, -65492, -65476, -65458, -65437, -65413, -65387, -65359, -65328, -65295, -65259, -65221, -65180, -65137, -65092, -65044, -64993, -64940, -64885, -64827, -64767, -64704, -64639, -64572, -64502, -64429, -64354, -64277, -64198, -64116, -64031, -63944, -63855, -63763, -63669, -63572, -63474, -63372, -63269, -63163, -63054, -62943, -62830, -62715, -62597, -62476, -62354, -62229, -62101, -61972, -61840, -61706, -61569, -61430, -61289, -61145, -60999, -60851, -60701, -60548, -60393, -60236, -60076, -59914, -59750, -59584, -59415, -59244, -59071, -58896, -58719, -58539, -58357, -58173, -57987, -57798, -57607, -57415, -57220, -57023, -56823, -56622, -56418, -56213, -56005, -55795, -55583, -55369, -55153, -54934, -54714, -54492, -54267, -54041, -53812, -53582, -53349, -53115, -52878, -52640, -52399, -52156, -51912, -51666, -51417, -51167, -50915, -50661, -50404, -50147, -49887, -49625, -49361, -49096, -48829, -48559, -48289, -48016, -47741, -47465, -47187, -46907, -46625, -46341, -46056, -45769, -45481, -45190, -44898, -44604, -44309, -44012, -43713, -43413, -43111, -42807, -42502, -42195, -41886, -41576, -41264, -40951, -40637, -40320, -40003, -39683, -39363, -39040, -38717, -38391, -38065, -37737, -37407, -37076, -36744, -36410, -36075, -35739, -35401, -35062, -34722, -34380, -34037, -33693, -33347, -33000, -32652, -32303, -31953, -31601, -31248, -30894, -30539, -30182, -29825, -29466, -29106, -28746, -28384, -28021, -27657, -27292, -26926, -26558, -26190, -25821, -25451, -25080, -24708, -24335, -23961, -23587, -23211, -22834, -22457, -22079, -21700, -21320, -20939, -20558, -20176, -19793, -19409, -19025, -18639, -18254, -17867, -17480, -17092, -16703, -16314, -15924, -15534, -15143, -14752, -14360, -13967, -13574, -13180, -12786, -12391, -11996, -11601, -11205, -10808, -10411, -10014, -9617, -9219, -8820, -8422, -8023, -7624, -7224, -6824, -6424, -6024, -5623, -5223, -4822, -4421, -4019, -3618, -3216, -2815, -2413, -2011, -1609, -1207, -805, -403, 0, 402, 804, 1206, 1608, 2010, 2412, 2814, 3215, 3617, 4018, 4420, 4821, 5222, 5622, 6023, 6423, 6823, 7223, 7623, 8022, 8421, 8819, 9218, 9616, 10013, 10410, 10807, 11204, 11600, 11995, 12390, 12785, 13179, 13573, 13966, 14359, 14751, 15142, 15533, 15923, 16313, 16702, 17091, 17479, 17866, 18253, 18638, 19024, 19408, 19792, 20175, 20557, 20938, 21319, 21699, 22078, 22456, 22833, 23210, 23586, 23960, 24334, 24707, 25079, 25450, 25820, 26189, 26557, 26925, 27291, 27656, 28020, 28383, 28745, 29105, 29465, 29824, 30181, 30538, 30893, 31247, 31600, 31952, 32302, 32651, 32999, 33346, 33692, 34036, 34379, 34721, 35061, 35400, 35738, 36074, 36409, 36743, 37075, 37406, 37736, 38064, 38390, 38716, 39039, 39362, 39682, 40002, 40319, 40636, 40950, 41263, 41575, 41885, 42194, 42501, 42806, 43110, 43412, 43712, 44011, 44308, 44603, 44897, 45189, 45480, 45768, 46055, 46340, 46624, 46906, 47186, 47464, 47740, 48015, 48288, 48558, 48828, 49095, 49360, 49624, 49886, 50146, 50403, 50660, 50914, 51166, 51416, 51665, 51911, 52155, 52398, 52639, 52877, 53114, 53348, 53581, 53811, 54040, 54266, 54491, 54713, 54933, 55152, 55368, 55582, 55794, 56004, 56212, 56417, 56621, 56822, 57022, 57219, 57414, 57606, 57797, 57986, 58172, 58356, 58538, 58718, 58895, 59070, 59243, 59414, 59583, 59749, 59913, 60075, 60235, 60392, 60547, 60700, 60850, 60998, 61144, 61288, 61429, 61568, 61705, 61839, 61971, 62100, 62228, 62353, 62475, 62596, 62714, 62829, 62942, 63053, 63162, 63268, 63371, 63473, 63571, 63668, 63762, 63854, 63943, 64030, 64115, 64197, 64276, 64353, 64428, 64501, 64571, 64638, 64703, 64766, 64826, 64884, 64939, 64992, 65043, 65091, 65136, 65179, 65220, 65258, 65294, 65327, 65358, 65386, 65412, 65436, 65457, 65475, 65491, 65505, 65516, 65524, 65531, 65534};
    }
}

