/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class StopWatchCanvas
extends Canvas
implements CommandListener,
Runnable {
    private final StopWatch midlet;
    private final Display display;
    private final Command exitCommand;
    private final Command helpCommand;
    private final int width;
    private final int height;
    private final int clockWidth;
    private final int clockHeight;
    private final int clockX;
    private final int clockY;
    private long clockStart;
    private long timeElapsed;
    private Font bigFont;
    private Font smallFont;
    private int bigFontH;
    private int bigFontW;
    private int smallFontH;
    private int smallFontW;
    private int tick1Size;
    private int tick2Size;
    private int tick3Size;
    private int nrLap = 0;
    private int lapMod = 0;
    private int maxLap;
    private static final int STATE_RESET = 0;
    private static final int STATE_STOP = 1;
    private static final int STATE_RUN = 2;
    private int clockState;
    private Alert aboutAlert;
    private Image[] lapImg;
    private long tmpLong;
    private String tmpStr;
    private volatile Thread animationThread = null;

    StopWatchCanvas(StopWatch stopWatch, Display display) {
        this.midlet = stopWatch;
        this.display = display;
        this.setCommandListener(this);
        this.helpCommand = new Command("Help", 5, 1);
        this.addCommand(this.helpCommand);
        this.exitCommand = new Command("Exit", 7, 1);
        this.addCommand(this.exitCommand);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.bigFont = Font.getFont((int)32, (int)1, (int)16);
        this.smallFont = Font.getFont((int)32, (int)0, (int)8);
        this.bigFontH = this.bigFont.getHeight();
        this.bigFontW = this.bigFont.stringWidth("00:00.00");
        this.smallFontH = this.smallFont.getHeight() + 2;
        this.smallFontW = this.smallFont.stringWidth("00:00.00");
        int n = this.height - this.bigFontH - 6;
        int n2 = this.width - this.smallFontW - 6;
        if (n2 > n) {
            this.clockWidth = n;
            this.clockHeight = n;
        } else {
            this.clockWidth = n2;
            this.clockHeight = n2;
        }
        this.clockX = 1 + n2 / 2;
        this.clockY = 1 + n / 2;
        this.tick1Size = this.clockWidth / 20;
        if (this.tick1Size < 1) {
            this.tick1Size = 1;
        }
        this.tick2Size = this.clockWidth / 15;
        if (this.tick2Size < 2) {
            this.tick2Size = 2;
        }
        this.tick3Size = this.clockWidth / 10;
        if (this.tick3Size < 3) {
            this.tick3Size = 3;
        }
        this.maxLap = n / this.smallFontH;
        this.lapImg = new Image[this.maxLap];
        for (int i = 0; i < this.maxLap; ++i) {
            this.lapImg[i] = Image.createImage((int)this.smallFontW, (int)this.smallFontH);
        }
        this.clockState = 0;
        this.aboutAlert = new Alert("StopWatch v1.3", "(C) 2003-2005 Andreas Gustafsson\n\"5\" - Start/stop\n\"0\" - Reset\n\"2\" - Split time\n\"8\" - Lap time\nContact me at:\nandreas.gustafsson@gmail.com", null, null);
        this.aboutAlert.setTimeout(-2);
    }

    void startAnimation() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    void stopAnimation() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = 25;
        Thread thread = Thread.currentThread();
        try {
            while (thread == this.animationThread) {
                long l = System.currentTimeMillis();
                this.repaint(0, 0, this.getWidth(), this.getHeight());
                this.serviceRepaints();
                StopWatchCanvas stopWatchCanvas = this;
                synchronized (stopWatchCanvas) {
                    this.wait(10L);
                }
                long l2 = System.currentTimeMillis() - l;
                if (l2 < (long)n) {
                    StopWatchCanvas stopWatchCanvas2 = this;
                    synchronized (stopWatchCanvas2) {
                        this.wait((long)n - l2);
                        continue;
                    }
                }
                thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        int n;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.width, this.height - this.bigFontH - 2);
        graphics.setColor(15460807);
        graphics.fillRect(0, this.height - this.bigFontH - 2, this.width, this.height);
        graphics.setColor(13161963);
        graphics.fillRect(this.width - this.smallFontW - 2, 0, this.width, this.height - this.bigFontH - 2);
        graphics.setColor(0);
        graphics.drawLine(0, this.height - this.bigFontH - 2, this.width, this.height - this.bigFontH - 2);
        graphics.drawLine(this.width - this.smallFontW - 3, 0, this.width - this.smallFontW - 3, this.height - this.bigFontH - 2);
        graphics.setColor(0xC0C0C0);
        graphics.setStrokeStyle(0);
        for (n = 0; n < 60; ++n) {
            graphics.drawLine(this.clockX + SdwUtil.CosCalc(this.clockWidth / 2, n * 1024 / 60), this.clockY + SdwUtil.SinCalc(this.clockHeight / 2, n * 1024 / 60), this.clockX + SdwUtil.CosCalc(this.clockWidth / 2 - this.tick1Size, n * 1024 / 60), this.clockY + SdwUtil.SinCalc(this.clockHeight / 2 - this.tick1Size, n * 1024 / 60));
        }
        graphics.setColor(0x808080);
        for (n = 0; n < 12; ++n) {
            graphics.drawLine(this.clockX + SdwUtil.CosCalc(this.clockWidth / 2, n * 1024 / 12), this.clockY + SdwUtil.SinCalc(this.clockHeight / 2, n * 1024 / 12), this.clockX + SdwUtil.CosCalc(this.clockWidth / 2 - this.tick2Size, n * 1024 / 12), this.clockY + SdwUtil.SinCalc(this.clockHeight / 2 - this.tick2Size, n * 1024 / 12));
        }
        graphics.setColor(0x404040);
        for (n = 0; n < 4; ++n) {
            graphics.drawLine(this.clockX + SdwUtil.CosCalc(this.clockWidth / 2, n * 1024 / 4), this.clockY + SdwUtil.SinCalc(this.clockHeight / 2, n * 1024 / 4), this.clockX + SdwUtil.CosCalc(this.clockWidth / 2 - this.tick3Size, n * 1024 / 4), this.clockY + SdwUtil.SinCalc(this.clockHeight / 2 - this.tick3Size, n * 1024 / 4));
        }
        switch (this.clockState) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.timeElapsed = System.currentTimeMillis() - this.clockStart;
            }
        }
        this.tmpLong = this.timeElapsed * 1000L / 58594L;
        int n2 = (int)(-this.tmpLong - 512L) & 0x3FF;
        graphics.setColor(0);
        graphics.drawLine(this.clockX, this.clockY, this.clockX + SdwUtil.SinCalc(this.clockWidth / 2, n2), this.clockY + SdwUtil.CosCalc(this.clockHeight / 2, n2));
        this.tmpLong = this.timeElapsed / 10L;
        n2 = (int)this.tmpLong % 100;
        this.tmpStr = n2 < 10 ? ".0" + n2 : "." + n2;
        this.tmpLong /= 100L;
        n2 = (int)this.tmpLong % 60;
        this.tmpStr = n2 < 10 ? ":0" + n2 + this.tmpStr : ":" + n2 + this.tmpStr;
        this.tmpLong /= 60L;
        n2 = (int)this.tmpLong % 60;
        this.tmpStr = n2 < 10 ? "0" + n2 + this.tmpStr : "" + n2 + this.tmpStr;
        graphics.setFont(this.bigFont);
        graphics.drawString(this.tmpStr, (this.width - this.bigFontW) / 2, this.height - this.bigFont.getHeight() - 1, 0x10 | 4);
        for (n = 0; n < this.nrLap; ++n) {
            graphics.drawImage(this.lapImg[(n + this.lapMod) % this.maxLap], this.width - this.smallFontW - 1, n * this.smallFontH, 0x10 | 4);
        }
    }

    public void keyPressed(int n) {
        block0 : switch (n) {
            case 48: {
                if (this.clockState != 1) break;
                this.timeElapsed = 0L;
                this.nrLap = 0;
                this.lapMod = 0;
                this.clockState = 0;
                break;
            }
            case 50: {
                switch (this.clockState) {
                    case 0: {
                        this.clockStart = System.currentTimeMillis();
                        this.clockState = 2;
                        break;
                    }
                    case 2: {
                        if (this.nrLap < this.maxLap) {
                            this.drawLapImage(this.nrLap);
                            ++this.nrLap;
                            break;
                        }
                        this.drawLapImage(this.lapMod);
                        this.lapMod = (this.lapMod + 1) % this.maxLap;
                    }
                }
                break;
            }
            case 53: {
                switch (this.clockState) {
                    case 0: {
                        this.clockStart = System.currentTimeMillis();
                        this.clockState = 2;
                        break;
                    }
                    case 1: {
                        this.clockStart = System.currentTimeMillis() - this.timeElapsed;
                        this.clockState = 2;
                        break;
                    }
                    case 2: {
                        this.clockState = 1;
                    }
                }
                break;
            }
            case 56: {
                switch (this.clockState) {
                    case 1: {
                        this.timeElapsed = 0L;
                        this.nrLap = 0;
                        this.lapMod = 0;
                        this.clockStart = System.currentTimeMillis();
                        this.clockState = 2;
                        break block0;
                    }
                    case 0: {
                        this.clockStart = System.currentTimeMillis();
                        this.clockState = 2;
                        break block0;
                    }
                    case 2: {
                        if (this.nrLap < this.maxLap) {
                            this.drawLapImage(this.nrLap);
                            ++this.nrLap;
                        } else {
                            this.drawLapImage(this.lapMod);
                            this.lapMod = (this.lapMod + 1) % this.maxLap;
                        }
                        this.clockStart = System.currentTimeMillis();
                        this.timeElapsed = 0L;
                    }
                }
            }
        }
    }

    public void drawLapImage(int n) {
        Graphics graphics = this.lapImg[n].getGraphics();
        graphics.setColor(13161963);
        graphics.fillRect(0, 0, this.smallFontW, this.smallFontH);
        graphics.setColor(0);
        this.tmpLong = this.timeElapsed / 10L;
        int n2 = (int)this.tmpLong % 100;
        this.tmpStr = n2 < 10 ? ".0" + n2 : "." + n2;
        this.tmpLong /= 100L;
        n2 = (int)this.tmpLong % 60;
        this.tmpStr = n2 < 10 ? ":0" + n2 + this.tmpStr : ":" + n2 + this.tmpStr;
        this.tmpLong /= 60L;
        n2 = (int)this.tmpLong % 60;
        this.tmpStr = n2 < 10 ? "0" + n2 + this.tmpStr : "" + n2 + this.tmpStr;
        graphics.setFont(this.smallFont);
        graphics.drawString(this.tmpStr, 0, 1, 0x10 | 4);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.stopAnimation();
            this.midlet.exitRequested();
        }
        if (command == this.helpCommand) {
            this.display.setCurrent((Displayable)this.aboutAlert);
        }
    }
}

