/*
 * Decompiled with CFR 0.152.
 */
package com.innograte.j2me.games.minefield;

import com.innograte.j2me.games.minefield.MinefieldMidlet;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class Splash
extends Canvas
implements CommandListener {
    public static final byte LOGO = 1;
    public static final byte SPLASH = 2;
    public static final byte FADING = 3;
    byte status;
    short canvasHeight;
    short canvasWidth;
    public Command startGameCommand = new Command("Start Game", 1, 1);
    public Command difficultyCommand = new Command("Difficulty Level", 1, 2);
    public Command highScoreCommand = new Command("High Scores", 1, 3);
    public Command helpCommand = new Command("Help", 1, 4);
    public Command aboutCommand = new Command("About", 1, 5);
    public Command quitCommand = new Command("Quit", 6, 9);
    private Command backCommand = new Command("Back", 2, 1);
    MinefieldMidlet bombsMidlet;
    Animator splashAnimator;
    Timer timer;
    Image logoImage;
    Image splashImage;
    Image splashBuffer;
    Graphics splashBufferGraphics;
    short fadingOffsetX = 0;
    short fadingOffsetY = 0;
    List difficultyList = new List("Difficulty Level", 3, MinefieldMidlet.DIFFICULTY_STRINGS, null);

    public Splash(MinefieldMidlet bombsmidlet, byte aStatus) {
        this.bombsMidlet = bombsmidlet;
        this.status = aStatus;
        try {
            this.canvasHeight = (short)this.getHeight();
            this.canvasWidth = (short)this.getWidth();
            this.logoImage = Image.createImage((String)"/images/logo.png");
            this.splashImage = Image.createImage((String)"/images/splash.png");
            this.splashBuffer = Image.createImage((int)this.canvasWidth, (int)this.canvasHeight);
            this.splashBufferGraphics = this.splashBuffer.getGraphics();
            this.setCommandListener(this);
            this.addCommand(this.startGameCommand);
            this.addCommand(this.difficultyCommand);
            this.addCommand(this.highScoreCommand);
            this.addCommand(this.helpCommand);
            this.addCommand(this.aboutCommand);
            this.addCommand(this.quitCommand);
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new Animator(), 50L, 50L);
            this.paint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.startGameCommand) {
            this.status = (byte)3;
        } else if (command == this.difficultyCommand) {
            this.difficultyList.setSelectedIndex(this.bombsMidlet.difficultyLevel, true);
            this.difficultyList.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this.bombsMidlet).setCurrent((Displayable)this.difficultyList);
        } else if (command == List.SELECT_COMMAND) {
            this.bombsMidlet.difficultyLevel = this.difficultyList.getSelectedIndex();
            Display.getDisplay((MIDlet)this.bombsMidlet).setCurrent((Displayable)this);
            this.status = (byte)3;
        } else if (command == this.quitCommand) {
            this.timer.cancel();
            MinefieldMidlet.quit();
        } else if (command == this.highScoreCommand) {
            this.bombsMidlet.highScore.displayHighScore((Displayable)this);
        } else if (command == this.helpCommand) {
            Form form = new Form("Help");
            form.append("Try to uncover the location of all the mines as fast as possible without setting one off. Use the arrow keys to move the pointer and the left function key to uncover the square. Use the number 9 key to flag squares and 7 to clear all close to flag.");
            form.addCommand(this.backCommand);
            form.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this.bombsMidlet).setCurrent((Displayable)form);
        } else if (command == this.aboutCommand) {
            Form form1 = new Form("About");
            form1.append(String.valueOf(String.valueOf(new StringBuffer("Minefield version ").append(MinefieldMidlet.VERSION).append(" by Patrik Ekstr\u00f6m, Innograte AB 2002."))));
            form1.addCommand(this.backCommand);
            form1.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this.bombsMidlet).setCurrent((Displayable)form1);
        } else if (command == this.backCommand) {
            Display.getDisplay((MIDlet)this.bombsMidlet).setCurrent((Displayable)this);
        }
    }

    public void paint() {
        switch (this.status) {
            case 2: {
                this.splashBufferGraphics.setColor(255, 255, 255);
                this.splashBufferGraphics.fillRect(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
                this.splashBufferGraphics.drawImage(this.splashImage, this.canvasWidth / 2, this.canvasHeight / 2, 3);
                break;
            }
            case 3: {
                this.splashBufferGraphics.setColor(255, 255, 255);
                this.splashBufferGraphics.fillRect(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
                if (this.fadingOffsetX >= this.canvasWidth / 2 || this.fadingOffsetY >= this.canvasHeight / 2) break;
                this.splashBufferGraphics.setClip((int)this.fadingOffsetX, (int)this.fadingOffsetY, this.canvasWidth - this.fadingOffsetX * 2, this.canvasHeight - this.fadingOffsetY * 2);
                this.splashBufferGraphics.drawImage(this.splashImage, 0, 0, 20);
                break;
            }
            case 1: {
                this.splashBufferGraphics.setColor(255, 255, 255);
                this.splashBufferGraphics.fillRect(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
                this.splashBufferGraphics.drawImage(this.logoImage, this.canvasWidth / 2, this.canvasHeight / 2, 3);
                break;
            }
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        g.drawImage(this.splashBuffer, 0, 0, 20);
    }

    static {
        LOGO = 1;
        SPLASH = (byte)2;
        FADING = (byte)3;
    }

    class Animator
    extends TimerTask {
        int timeElapsed = 0;

        Animator() {
        }

        public void run() {
            this.timeElapsed += 50;
            switch (Splash.this.status) {
                case 1: {
                    if (this.timeElapsed > 1500) {
                        Splash.this.status = (byte)2;
                        Splash.this.paint();
                        break;
                    }
                    Splash.this.paint();
                    break;
                }
                case 3: {
                    if (Splash.this.fadingOffsetX >= Splash.this.canvasWidth / 2) {
                        Splash.this.timer.cancel();
                        Splash.this.bombsMidlet.startMineCanvas();
                        break;
                    }
                    Splash.this.fadingOffsetX = (short)(Splash.this.fadingOffsetX + Splash.this.canvasWidth / 15);
                    Splash.this.fadingOffsetY = (short)(Splash.this.fadingOffsetY + Splash.this.canvasHeight / 15);
                    Splash.this.paint();
                    break;
                }
            }
        }
    }
}

