/*
 * Decompiled with CFR 0.152.
 */
package example.pushpuzzle;

import example.pushpuzzle.Board;
import example.pushpuzzle.PushPuzzle;
import example.pushpuzzle.PushPuzzleTimer;
import example.pushpuzzle.Score;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

class PushPuzzleCanvas
extends Canvas {
    private int level = 1;
    private boolean solved;
    private int cell = 1;
    private int w;
    private int h;
    private int bwidth;
    private int bheight;
    private Board board;
    private Score score;
    private PushPuzzle pushpuzzle;
    private Display display;
    private Timer timer;
    private TimerTask timertask;
    private CommandListener listener;
    private Form scoreForm;
    private TextBox levelText;
    private static int wallColor = 0x7F7F7F;
    private static int groundColor = 0xFFFFFF;
    private static int packetColor = 0;
    private static int storeColor = 0;
    private static int pusherColor = 0;
    private static boolean useDottedLine = false;

    public PushPuzzleCanvas(PushPuzzle pushPuzzle, Score score) {
        this.pushpuzzle = pushPuzzle;
        this.display = Display.getDisplay((MIDlet)pushPuzzle);
        this.score = score;
        this.board = new Board();
        this.initColors();
    }

    public void init() {
        this.h = this.getHeight();
        this.w = this.getWidth();
        this.level = this.score.getLevel();
        if (!this.readScreen(this.level)) {
            this.level = 0;
            this.readScreen(this.level);
        }
        this.repaint();
    }

    public void destroy() {
        this.cancelTo();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void initColors() {
        boolean bl = this.display.isColor();
        int n = this.display.numColors();
        if (bl) {
            this.setColors(27989, 0xFFFFFF, 16739584, 11927637, 0x6D6DFF);
        } else if (n > 2) {
            this.setColors(0x999999, 0xFFFFFF, 0x666666, 0xBBBBBB, 0);
        } else {
            this.setColors(0x6A6A6A, 0xFFFFFF, 0x6A6A6A, 0, 0);
            useDottedLine = true;
        }
    }

    private void setColors(int n, int n2, int n3, int n4, int n5) {
        if (n != -1) {
            wallColor = n;
        }
        if (n2 != -1) {
            groundColor = n2;
        }
        if (n3 != -1) {
            packetColor = n3;
        }
        if (n4 != -1) {
            storeColor = n4;
        }
        if (n5 != -1) {
            pusherColor = n5;
        }
    }

    private int parseColor(String string) {
        if (string == null) {
            return -1;
        }
        return Integer.parseInt(string, 16);
    }

    public void undoMove() {
        int n = this.board.undoMove();
        if (n >= 0) {
            this.repaintNear(this.board.getPusherLocation(), n);
        }
        this.solved = this.board.solved();
    }

    public void restartLevel() {
        this.readScreen(this.level);
        this.repaint();
        this.solved = false;
    }

    public boolean nextLevel(int n) {
        this.updateScores();
        if (this.level + n >= 0 && this.readScreen(this.level + n)) {
            this.level += n;
            this.score.setLevel(this.level);
            this.solved = false;
            return true;
        }
        return false;
    }

    public int getLevel() {
        return this.level;
    }

    public Screen getLevelScreen() {
        if (this.levelText == null) {
            this.levelText = new TextBox("Enter Level", Integer.toString(this.level), 4, 2);
        } else {
            this.levelText.setString(Integer.toString(this.level));
        }
        return this.levelText;
    }

    public boolean gotoLevel() {
        if (this.levelText != null) {
            String string = this.levelText.getString();
            int n = Integer.parseInt(string);
            this.updateScores();
            if (n >= 0 && this.readScreen(n)) {
                this.level = n;
                this.score.setLevel(this.level);
                this.solved = false;
                this.repaint();
                return true;
            }
        }
        return false;
    }

    private boolean readScreen(int n) {
        if (n <= 0) {
            this.board.screen0();
        } else {
            InputStream inputStream = null;
            try {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/example/pushpuzzle/data/screen." + n);
                if (inputStream == null) {
                    System.out.println("Could not find the game board for level " + n);
                    return false;
                }
                this.board.read(inputStream, n);
                inputStream.close();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        this.bwidth = this.board.getWidth();
        this.bheight = this.board.getHeight();
        this.cell = (this.h - 14) / this.bheight < this.w / this.bwidth ? (this.h - 14) / this.bheight : this.w / this.bwidth;
        return true;
    }

    public Screen getScoreScreen() {
        Form form = null;
        int n = this.board.getPushes();
        int n2 = this.score.getPushes();
        int n3 = this.board.getMoves();
        int n4 = this.score.getMoves();
        boolean bl = this.solved && (n2 == 0 || n < n2);
        form = new Form(null);
        form.append((Item)new StringItem(bl ? "New Best:\n" : "Current:\n", n + " pushes\n" + n3 + " moves"));
        form.append((Item)new StringItem(bl ? "Old Best:\n" : "Best:\n", n2 + " pushes\n" + n4 + " moves"));
        String string = "Scores";
        if (bl) {
            string = "Congratulations";
        }
        form.setTitle(string);
        return form;
    }

    protected void keyRepeated(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.keyPressed(n);
                break;
            }
        }
    }

    protected void keyPressed(int n) {
        boolean bl = false;
        Board board = this.board;
        synchronized (board) {
            this.cancelTo();
            int n2 = this.getGameAction(n);
            int n3 = 0;
            switch (n2) {
                case 2: {
                    n3 = 0;
                    break;
                }
                case 5: {
                    n3 = 3;
                    break;
                }
                case 6: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    n3 = 1;
                    break;
                }
                default: {
                    return;
                }
            }
            int n4 = this.board.getPusherLocation();
            int n5 = this.board.move(n3);
            this.repaintNear(n4, n5);
            if (!this.solved && this.board.solved()) {
                this.solved = true;
                bl = true;
            }
        }
        if (bl && this.listener != null) {
            this.listener.commandAction(List.SELECT_COMMAND, (Displayable)this);
        }
    }

    private void updateScores() {
        if (!this.solved) {
            return;
        }
        int n = this.score.getPushes();
        int n2 = this.board.getPushes();
        int n3 = this.board.getMoves();
        if (n == 0 || n2 < n) {
            this.score.setLevelScore(n2, n3);
        }
    }

    private void animateTo(int n, int n2) {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        if (this.timertask != null) {
            this.timertask.cancel();
            this.timertask = null;
        }
        this.timertask = new PushPuzzleTimer(this, this.board, n, n2);
        this.timer.schedule(this.timertask, 100L, 100L);
    }

    private void cancelTo() {
        if (this.timertask != null) {
            this.timertask.cancel();
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.animateTo(n / this.cell, n2 / this.cell);
    }

    public void setCommandListener(CommandListener commandListener) {
        super.setCommandListener(commandListener);
        this.listener = commandListener;
    }

    void repaintNear(int n, int n2) {
        int n3 = n & Short.MAX_VALUE;
        int n4 = n >> 16 & Short.MAX_VALUE;
        int n5 = 1;
        if (n2 >= 0) {
            ++n5;
            if ((n2 & 4) != 0) {
                ++n5;
            }
        }
        int n6 = 1;
        int n7 = 1;
        switch (n2 & 3) {
            case 1: {
                n4 -= n5 - 1;
                n7 = n5;
                break;
            }
            case 2: {
                n7 = n5;
                break;
            }
            case 3: {
                n6 = n5;
                break;
            }
            case 0: {
                n3 -= n5 - 1;
                n6 = n5;
            }
        }
        this.repaint(n3 * this.cell, n4 * this.cell, n6 * this.cell, n7 * this.cell);
    }

    protected void paint(Graphics graphics) {
        Board board = this.board;
        synchronized (board) {
            int n = 0;
            int n2 = 0;
            int n3 = this.bwidth;
            int n4 = this.bheight;
            int n5 = graphics.getClipX();
            int n6 = graphics.getClipY();
            int n7 = graphics.getClipWidth();
            int n8 = graphics.getClipHeight();
            n = n5 / this.cell;
            n2 = n6 / this.cell;
            n3 = (n5 + n7 + this.cell - 1) / this.cell;
            n4 = (n6 + n8 + this.cell - 1) / this.cell;
            if (n3 > this.bwidth) {
                n3 = this.bwidth;
            }
            if (n4 > this.bheight) {
                n4 = this.bheight;
            }
            graphics.setColor(groundColor);
            graphics.fillRect(0, 0, this.w, this.h);
            n2 = 0;
            while (n2 < n4) {
                n = 0;
                while (n < n3) {
                    byte by = this.board.get(n, n2);
                    switch (by & 0xFFFFFFF7) {
                        case 4: {
                            graphics.setColor(wallColor);
                            graphics.fillRect(n * this.cell, n2 * this.cell, this.cell, this.cell);
                            break;
                        }
                        case 2: 
                        case 3: {
                            graphics.setColor(packetColor);
                            graphics.fillRect(n * this.cell + 1, n2 * this.cell + 1, this.cell - 2, this.cell - 2);
                            break;
                        }
                        case 1: {
                            graphics.setColor(storeColor);
                            if (useDottedLine) {
                                graphics.setStrokeStyle(1);
                            }
                            graphics.drawRect(n * this.cell + 1, n2 * this.cell + 1, this.cell - 2, this.cell - 2);
                            break;
                        }
                    }
                    if ((by & 8) != 0) {
                        graphics.setColor(pusherColor);
                        graphics.fillArc(n * this.cell, n2 * this.cell, this.cell, this.cell, 0, 360);
                    }
                    ++n;
                }
                ++n2;
            }
            graphics.drawString("PushPuzzle Level " + this.level, 0, this.h - 14, 20);
        }
    }
}

