/*
 * Decompiled with CFR 0.152.
 */
package example.tilepuzzle;

import example.About;
import example.tilepuzzle.Options;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class Board
extends Canvas
implements CommandListener {
    MIDlet midlet;
    Display dpy;
    Options options;
    String letters = "RATEYOURMINDPAL";
    Font font;
    Piece blankp;
    Piece[] all;
    Piece[][] grid;
    Random rand;
    int gridx;
    int gridy;
    int gridw;
    int gridh;
    int cellw;
    int cellh;
    int cellyoff;
    int cellxoff;
    static final int CMD_ABOUT = 0;
    static final int CMD_EXIT = 1;
    static final int CMD_OPTIONS = 2;
    static final int CMD_RESET = 3;
    static final int CMD_START = 4;
    static final int CMD_UNLOCK = 5;
    static final int CMD_ZLAST = 6;
    Command[] cmd;
    static final int INITIALIZED = 0;
    static final int PLAYING = 1;
    static final int WON = 2;
    int gameState;
    boolean cheated;

    void D(String string) {
        System.out.println(string);
    }

    void setGrid(Piece piece, int n, int n2) {
        this.grid[n][n2] = piece;
        piece.setLocation(n, n2);
    }

    void moveBlank(int n, int n2) {
        this.setGrid(this.grid[n][n2], this.blankp.x, this.blankp.y);
        this.setGrid(this.blankp, n, n2);
    }

    void swap(int n, int n2, int n3, int n4) {
        Piece piece = this.grid[n][n2];
        this.setGrid(this.grid[n3][n4], n, n2);
        this.setGrid(piece, n3, n4);
    }

    boolean isSolved() {
        int n = 0;
        while (n < this.gridh) {
            int n2 = 0;
            while (n2 < this.gridw) {
                if (!this.grid[n2][n].isHome()) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    int randRange(int n) {
        int n2 = this.rand.nextInt() % n;
        if (n2 < 0) {
            n2 += n;
        }
        return n2;
    }

    void randomize_by_moving() {
        int n = 0;
        while (n < 100) {
            int n2 = 0;
            int n3 = 0;
            int n4 = (this.rand.nextInt() & 2) - 1;
            if ((this.rand.nextInt() & 1) == 0) {
                n3 = n4;
            } else {
                n2 = n4;
            }
            if (this.blankp.x + n3 < 0) {
                n3 = 1;
            }
            if (this.blankp.x + n3 == this.gridw) {
                n3 = -1;
            }
            if (this.blankp.y + n2 < 0) {
                n2 = 1;
            }
            if (this.blankp.y + n2 == this.gridh) {
                n2 = -1;
            }
            this.moveBlank(this.blankp.x + n3, this.blankp.y + n2);
            ++n;
        }
        while (this.blankp.x != this.gridw - 1) {
            this.moveBlank(this.blankp.x + 1, this.blankp.y);
        }
        while (this.blankp.y != this.gridh - 1) {
            this.moveBlank(this.blankp.x, this.blankp.y + 1);
        }
    }

    void shuffle() {
        int n;
        int n2 = this.gridw * this.gridh - 1;
        Piece[] pieceArray = new Piece[n2];
        System.arraycopy(this.all, 0, pieceArray, 0, n2);
        int n3 = 0;
        while (n3 < n2) {
            n = this.randRange(n2);
            Piece piece = pieceArray[n];
            pieceArray[n] = pieceArray[n3];
            pieceArray[n3] = piece;
            ++n3;
        }
        n = 0;
        while (n < n2) {
            this.setGrid(pieceArray[n], n / this.gridw, n % this.gridw);
            ++n;
        }
        this.setGrid(this.blankp, this.gridw - 1, this.gridh - 1);
    }

    void randomize(boolean bl) {
        int n;
        int n2;
        this.shuffle();
        if (bl) {
            n2 = 7;
            n = 0;
        } else {
            n2 = 0;
            n = 7;
        }
        int n3 = this.rand.nextInt() & 1;
        int n4 = this.rand.nextInt() & 1;
        if (n3 == 1 && n4 == 1) {
            n3 = 2;
            n4 = 0;
        }
        this.swap(n3, n4, this.all[n2].x, this.all[n2].y);
        this.swap((this.rand.nextInt() & 1) + 1, 3, this.all[n].x, this.all[n].y);
        if ((this.displacement() & 1) == 1) {
            this.swap(1, 3, 2, 3);
        }
    }

    int displacement() {
        boolean[] blArray = new boolean[this.gridw * this.gridh - 1];
        int n = 0;
        int n2 = 0;
        while (n2 < this.gridh) {
            int n3 = 0;
            while (n3 < this.gridw) {
                Piece piece = this.grid[n3][n2];
                if (piece != this.blankp) {
                    blArray[piece.serial] = true;
                    int n4 = 0;
                    while (n4 < piece.serial) {
                        if (!blArray[n4]) {
                            ++n;
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    void resetGrid() {
        Piece[] pieceArray = new Piece[this.gridw * this.gridh];
        int n = 0;
        int n2 = 0;
        while (n2 < this.gridw) {
            int n3 = 0;
            while (n3 < this.gridh) {
                pieceArray[n++] = this.grid[n2][n3];
                ++n3;
            }
            ++n2;
        }
        n = 0;
        while (n < pieceArray.length) {
            pieceArray[n].goHome();
            ++n;
        }
    }

    void rearrangeFunnily(boolean bl) {
        this.resetGrid();
        if (bl) {
            this.swap(0, 0, 3, 1);
            this.swap(2, 2, 3, 2);
            this.swap(3, 2, 0, 3);
            this.swap(0, 3, 2, 3);
        } else {
            this.swap(2, 2, 3, 2);
            this.swap(3, 2, 0, 3);
        }
    }

    void setState(int n) {
        this.gameState = n;
        switch (this.gameState) {
            case 0: {
                this.addCommand(this.cmd[0]);
                this.removeCommand(this.cmd[3]);
                this.addCommand(this.cmd[4]);
                this.addCommand(this.cmd[5]);
                this.addCommand(this.cmd[1]);
                this.addCommand(this.cmd[2]);
                break;
            }
            case 1: {
                this.addCommand(this.cmd[0]);
                this.addCommand(this.cmd[3]);
                this.removeCommand(this.cmd[4]);
                this.removeCommand(this.cmd[5]);
                this.addCommand(this.cmd[1]);
                this.addCommand(this.cmd[2]);
                break;
            }
            case 2: {
                this.addCommand(this.cmd[0]);
                this.removeCommand(this.cmd[3]);
                this.addCommand(this.cmd[4]);
                this.addCommand(this.cmd[5]);
                this.addCommand(this.cmd[1]);
                this.addCommand(this.cmd[2]);
            }
        }
    }

    public Board(MIDlet mIDlet) {
        this.midlet = mIDlet;
        this.dpy = Display.getDisplay((MIDlet)this.midlet);
        this.gridw = 4;
        this.gridh = 4;
        this.font = Font.getFont((int)0, (int)0, (int)0);
        this.cellw = this.font.charWidth('M') + 7;
        this.cellh = this.font.getHeight() + 1;
        this.cellxoff = 3;
        this.cellyoff = 0;
        this.gridx = (this.getWidth() - this.gridw * this.cellw + 1) / 2;
        this.gridy = 10;
        this.cheated = false;
        this.rand = new Random();
        this.grid = new Piece[this.gridw][];
        int n = 0;
        while (n < this.gridw) {
            this.grid[n] = new Piece[this.gridh];
            ++n;
        }
        this.all = new Piece[this.gridw * this.gridh];
        n = 0;
        while (n < this.gridw * this.gridh - 1) {
            int n2 = n % this.gridw;
            int n3 = n / this.gridw;
            String string = this.letters.substring(n, n + 1);
            this.grid[n2][n3] = this.all[n] = new Piece(string, n, n2, n3, n < this.gridw * this.gridh / 2);
            ++n;
        }
        this.grid[this.gridw - 1][this.gridh - 1] = this.blankp = new Piece(null, this.gridw * this.gridh - 1, this.gridw - 1, this.gridh - 1, false);
        this.all[this.gridw * this.gridh - 1] = this.blankp;
        this.cmd = new Command[6];
        this.cmd[0] = new BoardCommand("About", 5, 5, 0);
        this.cmd[1] = new BoardCommand("Exit", 7, 6, 1);
        this.cmd[2] = new BoardCommand("Options", 1, 3, 2);
        this.cmd[3] = new BoardCommand("Reset", 1, 1, 3);
        this.cmd[4] = new BoardCommand("Start", 1, 1, 4);
        this.cmd[5] = new BoardCommand("Unlock", 1, 4, 5);
        this.setCommandListener(this);
        this.options = new Options(this.dpy, (Displayable)this);
        this.setState(0);
    }

    public void commandAction(Command command, Displayable displayable) {
        switch (((BoardCommand)command).tag) {
            case 0: {
                About.showAbout(Display.getDisplay((MIDlet)this.midlet));
                break;
            }
            case 1: {
                this.midlet.notifyDestroyed();
                break;
            }
            case 2: {
                this.dpy.setCurrent((Displayable)this.options);
                break;
            }
            case 3: {
                this.cheated = false;
                this.resetGrid();
                this.setState(0);
                this.repaint();
                break;
            }
            case 4: {
                this.cheated = false;
                if (this.options.funny) {
                    this.rearrangeFunnily(this.options.hard);
                } else {
                    this.randomize(this.options.hard);
                }
                this.setState(1);
                this.repaint();
                break;
            }
            case 5: {
                this.cheated = true;
                this.setState(1);
                this.repaint();
            }
        }
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.translate(this.gridx, this.gridy);
        graphics.setColor(0);
        graphics.drawRect(-2, -2, this.gridw * this.cellw + 2, this.gridh * this.cellh + 2);
        int n = 0;
        while (n < this.gridw) {
            int n2 = 0;
            while (n2 < this.gridh) {
                this.grid[n][n2].paint(graphics);
                ++n2;
            }
            ++n;
        }
        if (this.gameState == 2) {
            graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
            graphics.setColor(0);
            graphics.setFont(Font.getDefaultFont());
            graphics.drawString(this.cheated ? "CHEATER!" : "YOU WIN!", this.getWidth() / 2, this.getHeight() - 1, 33);
        }
    }

    public void keyPressed(int n) {
        if (this.gameState != 1) {
            return;
        }
        int n2 = this.getGameAction(n);
        int n3 = this.blankp.x;
        int n4 = this.blankp.y;
        int n5 = this.options.reversed ? -1 : 1;
        switch (n2) {
            case 1: {
                n4 += n5;
                break;
            }
            case 6: {
                n4 -= n5;
                break;
            }
            case 2: {
                n3 += n5;
                break;
            }
            case 5: {
                n3 -= n5;
                break;
            }
            default: {
                return;
            }
        }
        if (n3 < 0 || n3 >= this.gridw || n4 < 0 || n4 >= this.gridh) {
            return;
        }
        this.moveBlank(n3, n4);
        this.repaint();
        if (this.isSolved()) {
            this.setState(2);
        }
    }

    class BoardCommand
    extends Command {
        int tag;

        BoardCommand(String string, int n, int n2, int n3) {
            super(string, n, n2);
            this.tag = n3;
        }
    }

    class Piece {
        String label;
        boolean inv;
        int serial;
        int ix;
        int iy;
        int x;
        int y;

        Piece(String string, int n, int n2, int n3, boolean bl) {
            this.label = string;
            this.serial = n;
            this.x = this.ix = n2;
            this.y = this.iy = n3;
            this.inv = bl;
        }

        void setLocation(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        boolean isHome() {
            return this.x == this.ix && this.y == this.iy;
        }

        void goHome() {
            Board.this.setGrid(this, this.ix, this.iy);
        }

        void paint(Graphics graphics) {
            int n = this.x * Board.this.cellw;
            int n2 = this.y * Board.this.cellh;
            if (this.label != null) {
                if (this.inv) {
                    graphics.setColor(0);
                    graphics.setFont(Board.this.font);
                    graphics.drawRect(n, n2, Board.this.cellw - 2, Board.this.cellh - 2);
                    graphics.drawString(this.label, n + Board.this.cellxoff, n2 + Board.this.cellyoff, 20);
                } else {
                    graphics.setColor(0);
                    graphics.fillRect(n, n2, Board.this.cellw - 1, Board.this.cellh - 1);
                    graphics.setColor(0xFFFFFF);
                    graphics.setFont(Board.this.font);
                    graphics.drawString(this.label, n + Board.this.cellxoff, n2 + Board.this.cellyoff, 20);
                }
            }
        }
    }
}

