/*
 * Decompiled with CFR 0.152.
 */
package example.wormgame;

import example.wormgame.WormException;
import example.wormgame.WormLink;
import example.wormgame.WormPit;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Worm {
    public static final byte DOWN = 2;
    public static final byte LEFT = 4;
    public static final byte RIGHT = 6;
    public static final byte UP = 8;
    private byte currentDirection;
    private Vector worm = new Vector(5, 2);
    private boolean needUpdate;
    private boolean moveOnNextUpdate;
    private boolean hasEaten;
    private static final int INIT_X = 3;
    private static final int INIT_Y = 8;
    private static final int INIT_LEN = 8;
    private static final byte INIT_DIR = 6;

    public Worm(WormPit wormPit) {
        this.regenerate();
    }

    public void regenerate() {
        Vector vector = this.worm;
        synchronized (vector) {
            this.worm.removeAllElements();
            this.worm.addElement(new WormLink(3, 8, 8, 6));
            this.currentDirection = (byte)6;
            this.needUpdate = false;
            this.hasEaten = false;
            this.moveOnNextUpdate = false;
        }
    }

    public void setDirection(byte by) {
        Vector vector = this.worm;
        synchronized (vector) {
            if (by != this.currentDirection && !this.needUpdate) {
                WormLink wormLink = (WormLink)this.worm.lastElement();
                int n = wormLink.getEndX();
                int n2 = wormLink.getEndY();
                switch (by) {
                    case 8: {
                        if (this.currentDirection == 2) break;
                        --n2;
                        this.needUpdate = true;
                        break;
                    }
                    case 2: {
                        if (this.currentDirection == 8) break;
                        ++n2;
                        this.needUpdate = true;
                        break;
                    }
                    case 4: {
                        if (this.currentDirection == 6) break;
                        --n;
                        this.needUpdate = true;
                        break;
                    }
                    case 6: {
                        if (this.currentDirection == 4) break;
                        ++n;
                        this.needUpdate = true;
                    }
                }
                if (this.needUpdate) {
                    this.worm.addElement(new WormLink(n, n2, 0, by));
                    this.currentDirection = by;
                }
            }
        }
    }

    public void moveOnUpdate() {
        Vector vector = this.worm;
        synchronized (vector) {
            this.moveOnNextUpdate = true;
        }
    }

    public void update(Graphics graphics) throws WormException {
        if (!this.moveOnNextUpdate) {
            return;
        }
        Vector vector = this.worm;
        synchronized (vector) {
            WormLink wormLink = (WormLink)this.worm.lastElement();
            wormLink.increaseLength();
            if (!this.hasEaten) {
                WormLink wormLink2 = (WormLink)this.worm.firstElement();
                int n = wormLink2.getX();
                int n2 = wormLink2.getY();
                wormLink2.decreaseLength();
                if (wormLink2.getLength() == 0) {
                    this.worm.removeElement(wormLink2);
                }
                graphics.setColor(0xFFFFFF);
                this.drawLink(graphics, n, n2, n, n2, 1);
            } else {
                this.hasEaten = false;
            }
            this.needUpdate = false;
            if (!WormPit.isInBounds(wormLink.getEndX(), wormLink.getEndY())) {
                throw new WormException("over the edge");
            }
            byte by = (byte)wormLink.getEndX();
            byte by2 = (byte)wormLink.getEndY();
            graphics.setColor(0);
            this.drawLink(graphics, by, by2, by, by2, 1);
            int n = 0;
            while (n < this.worm.size() - 1) {
                WormLink wormLink3 = (WormLink)this.worm.elementAt(n);
                if (wormLink3.contains(by, by2)) {
                    throw new WormException("you ate yourself");
                }
                ++n;
            }
        }
    }

    public void drawLink(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        n5 *= 5;
        if (n == n3) {
            n2 = n4 < n2 ? n4 * 5 : (n2 *= 5);
            graphics.fillRect(n *= 5, n2, 5, n5);
        } else {
            n = n3 < n ? n3 * 5 : (n *= 5);
            graphics.fillRect(n, n2 *= 5, n5, 5);
        }
    }

    public void paint(Graphics graphics) {
        int n = 0;
        while (n < this.worm.size()) {
            WormLink wormLink = (WormLink)this.worm.elementAt(n);
            int n2 = wormLink.getX();
            int n3 = wormLink.getEndX();
            int n4 = wormLink.getY();
            int n5 = wormLink.getEndY();
            int n6 = wormLink.getLength();
            this.drawLink(graphics, n2, n4, n3, n5, n6);
            ++n;
        }
    }

    public void eat() {
        this.hasEaten = true;
    }

    public int getX() {
        Vector vector = this.worm;
        synchronized (vector) {
            int n = ((WormLink)this.worm.lastElement()).getEndX();
            return n;
        }
    }

    public int getY() {
        Vector vector = this.worm;
        synchronized (vector) {
            int n = ((WormLink)this.worm.lastElement()).getEndY();
            return n;
        }
    }

    public boolean contains(int n, int n2) {
        Vector vector = this.worm;
        synchronized (vector) {
            int n3 = 0;
            while (n3 < this.worm.size()) {
                WormLink wormLink = (WormLink)this.worm.elementAt(n3);
                if (wormLink.contains(n, n2)) {
                    boolean bl = true;
                    return bl;
                }
                ++n3;
            }
        }
        return false;
    }
}

