/*
 * Decompiled with CFR 0.152.
 */
package example.wormgame;

public class WormLink {
    private int x;
    private int y;
    private int len;
    private byte dir;

    private WormLink() {
    }

    public WormLink(int n, int n2, int n3, byte by) {
        this.x = n;
        this.y = n2;
        this.dir = by;
        this.len = n3 - 1;
    }

    public WormLink(int n, int n2, byte by) {
        this(n, n2, 1, by);
    }

    public void increaseLength() {
        ++this.len;
    }

    public void decreaseLength() {
        --this.len;
        switch (this.dir) {
            case 4: {
                --this.x;
                break;
            }
            case 6: {
                ++this.x;
                break;
            }
            case 8: {
                --this.y;
                break;
            }
            case 2: {
                ++this.y;
            }
        }
    }

    public int getLength() {
        return this.len + 1;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getEndX() {
        if (this.dir == 4) {
            return this.x - this.len;
        }
        if (this.dir == 6) {
            return this.x + this.len;
        }
        return this.x;
    }

    public int getEndY() {
        if (this.dir == 2) {
            return this.y + this.len;
        }
        if (this.dir == 8) {
            return this.y - this.len;
        }
        return this.y;
    }

    public byte getDirection() {
        return this.dir;
    }

    public boolean contains(int n, int n2) {
        switch (this.dir) {
            case 4: {
                return n2 == this.y && n <= this.x && n >= this.getEndX();
            }
            case 6: {
                return n2 == this.y && n >= this.x && n <= this.getEndX();
            }
            case 8: {
                return n == this.x && n2 <= this.y && n2 >= this.getEndY();
            }
            case 2: {
                return n == this.x && n2 >= this.y && n2 <= this.getEndY();
            }
        }
        return false;
    }

    public String toString() {
        String string;
        switch (this.dir) {
            case 4: {
                string = "Left";
                break;
            }
            case 6: {
                string = "Right";
                break;
            }
            case 8: {
                string = "Up";
                break;
            }
            case 2: {
                string = "Down";
                break;
            }
            default: {
                string = "UNKNOWN -- " + this.dir;
            }
        }
        return " pos == [" + this.x + "," + this.y + "]" + " - [" + this.getEndX() + "," + this.getEndY() + "]" + "   len == " + this.getLength() + "   dir == " + string;
    }
}

