/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class TBookMIDlet
extends MIDlet
implements CommandListener {
    private Display fDisplay;
    private TBookCanvas fCanvas;
    private short[] fCharBuff;
    private short[] fCharOffset;
    private int fCharHeight;
    private byte[] fPageBuff;
    private int fCursorPos;
    private int gw;
    private int gh;
    private int fPagePos;
    private int fBookCursorPos;
    private int fPrevCursorPos;
    private boolean fAbout;
    private boolean fWordWrapEn = true;
    private boolean fLightMode;
    private boolean fDebugMode;
    private boolean fViewMode = false;
    private boolean fLastViewMode;
    private int fInfoMode;
    private int fBlockPos = 0;
    private int fBookSize;
    private int fHelpSize;
    private int fPaintTime;
    private int fBuffPos0 = -1;
    private int fBuffPos1 = -1;
    private int fBuffMode;
    private int fBackColor;
    private int fFontColor;
    private int fSpace;
    private final int fPageBuffSize;
    private final int fPagesStartSize;
    private int[] fPagesStart;
    private byte[] fBuff0;
    private byte[] fBuff1;
    private String fBookFile = "/book";
    private String fHelpFile = "/help";
    private String fInfoMsg;
    private String fLogo = "www.mjsoft.nm.ru";
    private String[] fFullHelp = new String[]{"1 full help", "2 keys", "3 word wrap", "4 first page", "5 save bookmark", "6 goto bookmark", "7 prev page", "9 light on/off", "0*# next page"};
    private String[] fShortHelp = new String[]{"1 full hlp", "2 keys", "3 w wrap", "4 first", "5 save mark", "6 goto mark", "7 prev", "9 light", "0*# next"};
    private String fTest = "Test message 1. Test message 2. Test message 3. Test message 4. ";

    public TBookMIDlet() {
        DataInputStream dataInputStream;
        InputStream inputStream;
        this.fPageBuffSize = 2000;
        this.fPagesStartSize = 200;
        this.fCharOffset = new short[256];
        this.fPageBuff = new byte[2000];
        this.fPagesStart = new int[200];
        this.fBuff0 = new byte[8192];
        this.fBuff1 = new byte[8192];
        this.fSetInfo(2, "mjBook reader 2.5");
        this.fBackColor = 0xFFFFFF;
        this.fFontColor = 0;
        this.fDisplay = Display.getDisplay((MIDlet)this);
        this.fCanvas = new TBookCanvas(this);
        this.fDisplay.setCurrent((Displayable)this.fCanvas);
        this.fCanvas.repaint();
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/font.dat");
            dataInputStream = new DataInputStream(inputStream);
            this.fCharHeight = dataInputStream.readByte();
            int n = dataInputStream.readShort();
            this.fCharBuff = new short[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < 256) {
                n = dataInputStream.readByte();
                this.fCharOffset[n3] = (short)n2;
                this.fCharBuff[n2++] = n;
                if (n > 0) {
                    int n4 = 0;
                    while (n4 < n) {
                        this.fCharBuff[n2++] = dataInputStream.readShort();
                        ++n4;
                    }
                }
                ++n3;
            }
            dataInputStream.close();
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/font.dat");
            dataInputStream = new DataInputStream(inputStream);
            this.fCharHeight = dataInputStream.readByte();
        }
        catch (Exception exception) {
            System.out.println("font io error: " + exception.getMessage());
        }
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/cfg.dat");
            dataInputStream = new DataInputStream(inputStream);
            this.fHelpSize = dataInputStream.readInt();
            this.fBookSize = dataInputStream.readInt();
            this.fBackColor = dataInputStream.readInt();
            this.fFontColor = dataInputStream.readInt();
        }
        catch (Exception exception) {
            System.out.println("cfg io error: " + exception.getMessage());
        }
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public synchronized void paint(Graphics graphics) {
        long l = System.currentTimeMillis();
        switch (this.fInfoMode) {
            case 1: 
            case 2: 
            case 4: {
                this.paintInfoMsg(graphics);
                break;
            }
            default: {
                this.paintOffScreen(graphics);
                if (this.fInfoMode != 3) break;
                this.fInfoMode = 1;
                this.paintInfoMsg(graphics);
            }
        }
        if (this.fDebugMode) {
            this.paintDebugMsg(graphics);
        }
        this.fPaintTime = (int)(System.currentTimeMillis() - l);
    }

    private void paintInfoMsg(Graphics graphics) {
        switch (this.fInfoMode) {
            case 2: {
                this.gw = graphics.getClipWidth();
                this.gh = graphics.getClipHeight();
                if (this.gh == 144) {
                    this.gh = 208;
                }
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, this.gw, this.gh);
                Font font = Font.getFont((int)0, (int)0, (int)8);
                graphics.setFont(font);
                int n3 = font.getHeight();
                int n2 = font.stringWidth(this.fLogo);
                graphics.setColor(0);
                graphics.drawString(this.fLogo, this.gw - n2 >> 1, this.gh - n3 - 2, 0x10 | 4);
            }
            case 1: {
                Font font = Font.getFont((int)0, (int)0, (int)8);
                graphics.setFont(font);
                int n2 = font.stringWidth(this.fInfoMsg);
                int n = n2 + 4;
                int n3 = font.getHeight() + 5;
                int n4 = this.gw - n >> 1;
                int n5 = 8;
                graphics.setColor(16766432);
                graphics.fillRect(n4, n5, n, n3);
                graphics.setColor(0);
                graphics.drawRect(n4, n5, n, n3);
                int n6 = n5 + n3 + 1;
                graphics.drawLine(n4 + 1, n6, n4 + n, n6);
                int n7 = n4 + n + 1;
                graphics.drawLine(n7, n5 + 1, n7, n6);
                graphics.drawString(this.fInfoMsg, n4 + 3, n5 + 3, 0x10 | 4);
                this.fInfoMode = 1;
                break;
            }
            case 4: {
                Font font = Font.getFont((int)0, (int)0, (int)8);
                graphics.setFont(font);
                int n = this.gw - 8;
                int n8 = this.gh - 8;
                int n9 = 2;
                int n10 = 2;
                graphics.setColor(16766432);
                graphics.fillRect(n9, n10, n, n8);
                graphics.setColor(0);
                graphics.drawRect(n9, n10, n, n8);
                int n11 = n10 + n8 + 1;
                graphics.drawLine(n9 + 1, n11, n9 + n, n11);
                int n12 = n9 + n + 1;
                graphics.drawLine(n12, n10 + 1, n12, n11);
                if (this.gh >= 128) {
                    this.fDrawMenu(graphics, font, this.fFullHelp, n8, n, n9 + 2, n10 + 4);
                } else {
                    this.fDrawMenu(graphics, font, this.fShortHelp, n8, n, n9 + 2, n10 + 4);
                }
                this.fInfoMode = 1;
            }
        }
    }

    private void paintDebugMsg(Graphics graphics) {
        Font font = Font.getFont((int)0, (int)0, (int)8);
        graphics.setFont(font);
        int n = font.getHeight();
        graphics.setColor(0xB0C000);
        graphics.fillRect(0, this.gh - n * 2 - 3, this.gw, n * 2 + 3);
        graphics.setColor(0);
        String string = this.fCursorPos + "," + this.fBuffMode + "," + this.fBuffPos0 + "," + this.fBuffPos1 + "," + this.fPaintTime + " ms";
        graphics.drawString(string, 1, this.gh - n * 2 - 2, 0x10 | 4);
        string = Runtime.getRuntime().freeMemory() + "," + Runtime.getRuntime().totalMemory();
        graphics.drawString(string, 1, this.gh - n - 2, 0x10 | 4);
    }

    private void fDrawMenu(Graphics graphics, Font font, String[] stringArray, int n, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        int n7 = font.getHeight();
        int n8 = 2;
        int n9 = 0;
        int n10 = 0;
        while (n10 < stringArray.length) {
            graphics.drawString(stringArray[n10], n5 + n8, n6, 20);
            n6 = n6 + n7 + 2;
            if (n6 + n7 + 2 > n) {
                n9 = 0;
                int n11 = n10 + 1;
                while (n11 < stringArray.length) {
                    int n12 = font.stringWidth(stringArray[n11]);
                    if (n12 > n9) {
                        n9 = n12;
                    }
                    ++n11;
                }
                n5 = n2 - n9 - 4;
                n6 = n4;
            }
            ++n10;
        }
    }

    private void fLoadBuff(int n, int n2) {
        int n3 = 0;
        try {
            String string = this.fViewMode ? "/book" : "/help";
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string + n2 + ".dat");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (n == 0) {
                int n4 = 0;
                while (n4 < this.fBuff0.length) {
                    this.fBuff0[n4] = 0;
                    ++n4;
                }
                n3 = dataInputStream.read(this.fBuff0);
            } else {
                int n5 = 0;
                while (n5 < this.fBuff1.length) {
                    this.fBuff1[n5] = 0;
                    ++n5;
                }
                n3 = dataInputStream.read(this.fBuff1);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("data io error: " + exception.getMessage());
        }
    }

    private synchronized void showPage() {
        int n;
        int n2;
        if (this.fLastViewMode != this.fViewMode) {
            this.fLastViewMode = this.fViewMode;
            n2 = 0;
            while (n2 < this.fPagesStart.length) {
                this.fPagesStart[n2] = 0;
                ++n2;
            }
            this.fPagePos = 0;
            this.fCursorPos = 0;
            this.fBuffPos0 = -1;
            this.fBuffPos1 = -1;
        }
        int n3 = this.fCursorPos & 0x1FFF;
        int n4 = this.fCursorPos >> 13;
        int n5 = this.fCursorPos + 2000 >> 13;
        int n6 = 8192 - n3;
        if (n6 > 2000) {
            n6 = 2000;
            n = 0;
        } else {
            n = 2000 - n6;
        }
        if (n4 == n5) {
            n5 = n4 + 1;
        }
        int n7 = 0;
        if (n4 == this.fBuffPos0) {
            if (n5 == this.fBuffPos1) {
                this.fBuffMode = 1;
            } else {
                this.fLoadBuff(1, n5);
                this.fBuffMode = 2;
            }
            this.fBuffPos0 = n4;
            this.fBuffPos1 = n5;
            n2 = n3;
            while (n2 < n3 + n6) {
                this.fPageBuff[n7++] = this.fBuff0[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                this.fPageBuff[n7++] = this.fBuff1[n2];
                ++n2;
            }
        } else if (n4 == this.fBuffPos1) {
            if (n5 == this.fBuffPos0) {
                this.fBuffMode = 3;
            } else {
                this.fLoadBuff(0, n5);
                this.fBuffMode = 4;
            }
            this.fBuffPos1 = n4;
            this.fBuffPos0 = n5;
            n2 = n3;
            while (n2 < n3 + n6) {
                this.fPageBuff[n7++] = this.fBuff1[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                this.fPageBuff[n7++] = this.fBuff0[n2];
                ++n2;
            }
        } else if (n5 == this.fBuffPos0) {
            this.fLoadBuff(1, n4);
            this.fBuffMode = 5;
            this.fBuffPos1 = n4;
            this.fBuffPos0 = n5;
            n2 = n3;
            while (n2 < n3 + n6) {
                this.fPageBuff[n7++] = this.fBuff1[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                this.fPageBuff[n7++] = this.fBuff0[n2];
                ++n2;
            }
        } else {
            if (n5 == this.fBuffPos1) {
                this.fLoadBuff(0, n4);
                this.fBuffMode = 6;
            } else {
                this.fLoadBuff(0, n4);
                this.fLoadBuff(1, n5);
                this.fBuffMode = 7;
            }
            this.fBuffPos0 = n4;
            this.fBuffPos1 = n5;
            n2 = n3;
            while (n2 < n3 + n6) {
                this.fPageBuff[n7++] = this.fBuff0[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                this.fPageBuff[n7++] = this.fBuff1[n2];
                ++n2;
            }
        }
    }

    private boolean isAlpha(int n) {
        int[] nArray = new int[]{32, 33, 44, 45, 58, 59, 63};
        int n2 = 0;
        while (n2 < nArray.length - 1) {
            if (nArray[n2] == n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private int getStrLen(int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        int n5 = n;
        while (n5 < 1999) {
            int n6 = this.fPageBuff[n5] & 0xFF;
            if (n6 == 13) {
                return n5 - n + 1;
            }
            if (n6 == 0) {
                return n5 - n;
            }
            boolean bl = this.isAlpha(n6);
            if (!bl) {
                n4 = n5;
            }
            if ((n3 += this.fCharBuff[this.fCharOffset[n6]]) > n2) {
                if (bl & this.fWordWrapEn & n4 >= n) {
                    return n4 - n + 1;
                }
                return n5 - n;
            }
            ++n5;
        }
        return 1;
    }

    private void paintOffScreen(Graphics graphics) {
        block12: {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            graphics.setColor(this.fBackColor);
            graphics.fillRect(0, 0, this.gw, this.gh);
            graphics.setColor(this.fFontColor);
            int n4 = 0;
            boolean bl2 = false;
            this.fPrevCursorPos = this.fCursorPos;
            try {
                int n5;
                n = 0;
                while (n < 1999) {
                    int n6 = n4;
                    int n7 = this.getStrLen(n4, this.gw - 2);
                    if (n7 == 0) break;
                    this.fCursorPos += n7;
                    n2 = 1;
                    int n8 = 0;
                    while (n8 < n7) {
                        int n9;
                        int n10 = this.fCharOffset[this.fPageBuff[n4++] & 0xFF];
                        if ((n9 = this.fCharBuff[n10++]) > 0) {
                            int n11 = 0;
                            while (n11 < n9) {
                                n5 = this.fCharBuff[n10++];
                                int n12 = 0;
                                int n13 = 0;
                                while (n13 < this.fCharHeight) {
                                    if ((n5 & 1) != 0) {
                                        ++n12;
                                    } else if (n12 != 0) {
                                        graphics.fillRect(n2 + n11, n3 + n13 - n12, 1, n12);
                                        n12 = 0;
                                    }
                                    n5 >>= 1;
                                    ++n13;
                                }
                                if (n12 != 0) {
                                    graphics.fillRect(n2 + n11, n3 + n13 - n12, 1, n12);
                                }
                                ++n11;
                            }
                            n2 += n9;
                        }
                        ++n8;
                    }
                    if ((n3 += this.fCharHeight) + this.fCharHeight > this.gh) break;
                    ++n;
                }
                n5 = this.fViewMode ? this.fBookSize : this.fHelpSize;
                if (n5 == 0) {
                    graphics.setColor(255, 0, 0);
                    graphics.fillRect(this.gw - 1, 0, 1, this.gh);
                    break block12;
                }
                n3 = this.fCursorPos * this.gh / n5;
                graphics.setColor(0, 255, 0);
                graphics.fillRect(this.gw - 1, 0, 1, n3);
                graphics.setColor(255, 0, 0);
                graphics.fillRect(this.gw - 1, n3, 1, this.gh);
            }
            catch (Exception exception) {}
        }
    }

    public void keyPressed(int n, int n2) {
        if (this.fInfoMode == 1) {
            this.fCursorPos = this.fPrevCursorPos;
            this.showPage();
            this.fInfoMode = 0;
        } else {
            block0 : switch (n) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    break;
                }
                default: {
                    switch (n2) {
                        case 2: {
                            n = 55;
                            break block0;
                        }
                        case 5: {
                            n = 48;
                            break block0;
                        }
                        case 6: {
                            n = 48;
                            break block0;
                        }
                        case 1: {
                            n = 55;
                            break block0;
                        }
                        case 8: {
                            n = 53;
                        }
                    }
                }
            }
            switch (n) {
                case 49: {
                    this.fSetInfo(3, "help review");
                    this.fViewMode = false;
                    this.fCursorPos = 0;
                    this.fPrevCursorPos = 0;
                    this.showPage();
                    break;
                }
                case 51: {
                    boolean bl = this.fWordWrapEn = !this.fWordWrapEn;
                    if (this.fWordWrapEn) {
                        this.fSetInfo(1, "word wrap on");
                        break;
                    }
                    this.fSetInfo(1, "word wrap off");
                    break;
                }
                case 52: {
                    this.fSetInfo(3, "book review");
                    this.fViewMode = true;
                    this.fCursorPos = 0;
                    this.fPrevCursorPos = 0;
                    this.showPage();
                    break;
                }
                case 57: {
                    boolean bl = this.fLightMode = !this.fLightMode;
                    if (this.fLightMode) {
                        this.fSetInfo(1, "light on");
                    } else {
                        this.fSetInfo(1, "light off");
                    }
                    this.fCanvas.light(this.fLightMode);
                    break;
                }
                case 55: {
                    this.fPagesStart[this.fPagePos] = 0;
                    --this.fPagePos;
                    if (this.fPagePos < 0) {
                        this.fPagePos = this.fPagesStart.length - 1;
                    }
                    this.fCursorPos = this.fPagesStart[this.fPagePos];
                    this.showPage();
                    break;
                }
                case 53: {
                    if (!this.fViewMode) break;
                    this.fSetInfo(1, "bookmark saved");
                    this.fSaveBookMark();
                    break;
                }
                case 54: {
                    if (!this.fViewMode) break;
                    this.fSetInfo(3, "bookmark loaded");
                    this.fViewMode = true;
                    ++this.fPagePos;
                    if (this.fPagePos >= this.fPagesStart.length) {
                        this.fPagePos = 0;
                    }
                    this.fLoadBookMark();
                    this.fPagesStart[this.fPagePos] = this.fCursorPos;
                    this.fPrevCursorPos = this.fCursorPos;
                    this.showPage();
                    break;
                }
                case 50: {
                    this.fInfoMode = 4;
                    break;
                }
                case 56: {
                    boolean bl = this.fDebugMode = !this.fDebugMode;
                    if (this.fDebugMode) {
                        this.fSetInfo(3, "debug mode on");
                        break;
                    }
                    this.fSetInfo(3, "debug mode off");
                    break;
                }
                default: {
                    ++this.fPagePos;
                    if (this.fPagePos >= this.fPagesStart.length) {
                        this.fPagePos = 0;
                    }
                    this.fPagesStart[this.fPagePos] = this.fCursorPos;
                    this.showPage();
                }
            }
        }
        this.fCanvas.repaint();
        this.fCanvas.serviceRepaints();
    }

    private void fLoadBookMark() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"book", (boolean)true);
            byte[] byArray = recordStore.getRecord(1);
            int n = 0;
            int n2 = 2;
            while (n2 >= 0) {
                n <<= 7;
                n |= byArray[n2] & 0x7F;
                --n2;
            }
            this.fCursorPos = n;
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println("read store error " + recordStoreException.getMessage());
        }
    }

    private void fSaveBookMark() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"book", (boolean)true);
            int n = recordStore.getNumRecords();
            byte[] byArray = new byte[4];
            int n2 = this.fPrevCursorPos;
            int n3 = 0;
            while (n3 < 3) {
                byArray[n3] = (byte)(n2 & 0x7F);
                n2 >>= 7;
                ++n3;
            }
            if (n == 0) {
                recordStore.addRecord(byArray, 0, 3);
            } else {
                recordStore.setRecord(1, byArray, 0, 3);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println("save error " + recordStoreException.getMessage());
        }
    }

    private void fSetInfo(int n, String string) {
        this.fInfoMode = n;
        this.fInfoMsg = string;
    }
}

